/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.XSString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class FnCompare
extends Function {
    private static Collection _expected_args = null;

    public FnCompare() {
        super(new QName("compare"), 2, 3);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnCompare.compare(args, ec.getDynamicContext());
    }

    public static ResultSequence compare(Collection args, DynamicContext context) throws DynamicError {
        XSString xstr2;
        XSString xstr1;
        BigInteger result;
        Collection cargs = Function.convert_arguments(args, FnCompare.expected_args());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        ResultSequence arg2 = (ResultSequence)argiter.next();
        String collationUri = context.getCollationProvider().getDefaultCollation();
        if (argiter.hasNext()) {
            ResultSequence collArg = (ResultSequence)argiter.next();
            collationUri = collArg.first().getStringValue();
        }
        if ((result = FnCompare.compare_string(collationUri, xstr1 = arg1.empty() ? null : (XSString)arg1.first(), xstr2 = arg2.empty() ? null : (XSString)arg2.first(), context)) != null) {
            return new XSInteger(result);
        }
        return ResultBuffer.EMPTY;
    }

    public static BigInteger compare_string(String collationUri, XSString xstr1, XSString xstr2, DynamicContext context) throws DynamicError {
        Comparator<String> collator = context.getCollationProvider().getCollation(collationUri);
        if (collator == null) {
            throw DynamicError.unsupported_collation(collationUri);
        }
        if (xstr1 == null || xstr2 == null) {
            return null;
        }
        int ret = collator.compare(xstr1.value(), xstr2.value());
        if (ret == 0) {
            return BigInteger.ZERO;
        }
        if (ret < 0) {
            return BigInteger.valueOf(-1L);
        }
        return BigInteger.ONE;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

