/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.util.Collection;

public class FnBoolean
extends Function {
    public FnBoolean() {
        super(new QName("boolean"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnBoolean.fn_boolean(argument);
    }

    public static XSBoolean fn_boolean(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return XSBoolean.FALSE;
        }
        Item at = arg.item(0);
        if (at instanceof CalendarType) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof NodeType) {
            return XSBoolean.TRUE;
        }
        if (arg.size() > 1) {
            throw DynamicError.throw_type_error();
        }
        if (!(at instanceof AnyAtomicType)) {
            return XSBoolean.TRUE;
        }
        if (at instanceof XSBoolean && !((XSBoolean)at).value()) {
            return XSBoolean.FALSE;
        }
        if ((at instanceof XSString || at instanceof XSUntypedAtomic) && ((AnyType)at).getStringValue().equals("")) {
            return XSBoolean.FALSE;
        }
        if (at instanceof NumericType && ((NumericType)at).zero()) {
            return XSBoolean.FALSE;
        }
        if (at instanceof XSFloat && ((XSFloat)at).nan()) {
            return XSBoolean.FALSE;
        }
        if (at instanceof XSDouble && ((XSDouble)at).nan()) {
            return XSBoolean.FALSE;
        }
        return XSBoolean.TRUE;
    }
}

