/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Node;

public class FnBaseUri
extends Function {
    private static Collection _expected_args = null;

    public FnBaseUri() {
        super(new QName("base-uri"), 0, 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnBaseUri.base_uri(args, ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResultSequence base_uri(Collection args, EvaluationContext ec) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnBaseUri.expected_args());
        ResultSequence rs = null;
        if (cargs.size() == 0) {
            Item contextItem = ec.getContextItem();
            if (contextItem == null) throw DynamicError.contextUndefined();
            return FnBaseUri.getBaseUri(contextItem);
        }
        if (cargs.size() != 1) throw DynamicError.throw_type_error();
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        Item att = arg1.empty() ? null : arg1.first();
        return FnBaseUri.getBaseUri(att);
    }

    public static ResultSequence getBaseUri(Item att) {
        ResultBuffer rs = new ResultBuffer();
        XSAnyURI baseUri = null;
        if (att instanceof NodeType) {
            NodeType node = (NodeType)att;
            Node domNode = node.node_value();
            String buri = domNode.getBaseURI();
            baseUri = buri != null ? new XSAnyURI(buri) : new XSAnyURI("null");
        }
        if (baseUri != null) {
            rs.add(baseUri);
        }
        return rs.getSequence();
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(3));
        }
        return _expected_args;
    }
}

