/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class FnAdjustTimeToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustTimeToTimeZone() {
        super(new QName("adjust-time-to-timezone"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnAdjustTimeToTimeZone.adjustTime(args, ec.getDynamicContext());
    }

    public static ResultSequence adjustTime(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustTimeToTimeZone.expectedArgs());
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence arg2 = ResultBuffer.EMPTY;
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSTime time = (XSTime)arg1.first();
        XSDayTimeDuration timezone = null;
        if (arg2.empty()) {
            if (time.timezoned()) {
                XSTime localized = new XSTime(time.calendar(), null);
                return localized;
            }
            return arg1;
        }
        XMLGregorianCalendar xmlCalendar = null;
        xmlCalendar = time.tz() != null ? _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)time.normalizeCalendar(time.calendar(), time.tz())) : _datatypeFactory.newXMLGregorianCalendarTime(time.hour(), time.minute(), (int)time.second(), 0);
        timezone = (XSDayTimeDuration)arg2.first();
        if (timezone.lt(minDuration, dc) || timezone.gt(maxDuration, dc)) {
            throw DynamicError.invalidTimezone();
        }
        if (time.tz() == null) {
            return new XSTime(time.calendar(), timezone);
        }
        Duration duration = _datatypeFactory.newDuration(timezone.getStringValue());
        xmlCalendar.add(duration);
        return new XSTime(xmlCalendar.toGregorianCalendar(), timezone);
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSTime(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

