/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.FnCompare;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NaNable;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.math.BigInteger;
import java.util.ListIterator;

public abstract class AbstractCollationEqualFunction
extends Function {
    public AbstractCollationEqualFunction(QName name, int arity) {
        super(name, arity);
    }

    public AbstractCollationEqualFunction(QName name, int min_arity, int max_arity) {
        super(name, min_arity, max_arity);
    }

    protected static boolean hasValue(AnyType itema, AnyType itemb, DynamicContext context, String collationURI) throws DynamicError {
        return AbstractCollationEqualFunction.hasValue(itema, itemb, context, collationURI, false);
    }

    protected static boolean hasValue(AnyType itema, AnyType itemb, DynamicContext context, String collationURI, boolean nanEqualsNan) throws DynamicError {
        if (!(itema instanceof CmpEq) && !(itema instanceof XSUntypedAtomic)) {
            return false;
        }
        if (nanEqualsNan && itema instanceof NaNable && itemb instanceof NaNable && ((NaNable)((Object)itema)).nan() && ((NaNable)((Object)itemb)).nan()) {
            return true;
        }
        if (AbstractCollationEqualFunction.isBoolean(itema, itemb)) {
            return ((XSBoolean)itema).eq(itemb, context);
        }
        if (AbstractCollationEqualFunction.isNumeric(itema, itemb)) {
            return ((NumericType)itema).eq(itemb, context);
        }
        if (AbstractCollationEqualFunction.isDuration(itema, itemb)) {
            return ((XSDuration)itema).eq(itemb, context);
        }
        if (itema instanceof QName && itemb instanceof QName) {
            return ((QName)itema).eq(itemb, context);
        }
        if (AbstractCollationEqualFunction.needsStringComparison(itema, itemb)) {
            return BigInteger.ZERO.equals(FnCompare.compare_string(collationURI, new XSString(itema.getStringValue()), new XSString(itemb.getStringValue()), context));
        }
        return false;
    }

    protected static boolean hasValue(ResultBuffer rs, AnyAtomicType item, DynamicContext context, String collationURI) throws DynamicError {
        return AbstractCollationEqualFunction.hasValue(rs, item, context, collationURI, false);
    }

    protected static boolean hasValue(ResultBuffer rs, AnyAtomicType item, DynamicContext context, String collationURI, boolean nanEqualsNan) throws DynamicError {
        ListIterator<Item> i = rs.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            if (!AbstractCollationEqualFunction.hasValue(item, at, context, collationURI, nanEqualsNan)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDuration(AnyAtomicType item, AnyType at) {
        return at instanceof XSDuration && item instanceof XSDuration;
    }

    protected static boolean isBoolean(AnyAtomicType item, AnyType at) {
        return at instanceof XSBoolean && item instanceof XSBoolean;
    }

    protected static boolean isNumeric(AnyAtomicType item, AnyType at) {
        return at instanceof NumericType && item instanceof NumericType;
    }

    protected static boolean needsStringComparison(AnyAtomicType item, AnyType at) {
        AnyAtomicType anyItem = item;
        return AbstractCollationEqualFunction.needsStringComparison((AnyType)anyItem, at);
    }

    protected static boolean isDuration(AnyType item, AnyType at) {
        return at instanceof XSDuration && item instanceof XSDuration;
    }

    protected static boolean isDate(AnyType item, AnyType at) {
        return at instanceof XSDateTime && item instanceof XSDateTime;
    }

    protected static boolean isBoolean(AnyType cmptype, AnyType at) {
        return at instanceof XSBoolean && cmptype instanceof XSBoolean;
    }

    protected static boolean isNumeric(AnyType item, AnyType at) {
        return at instanceof NumericType && item instanceof NumericType;
    }

    protected static boolean needsStringComparison(AnyType item, AnyType at) {
        if (item instanceof NumericType) {
            XSDouble d;
            XSFloat f;
            if (at instanceof XSFloat && (f = (XSFloat)at).nan()) {
                return true;
            }
            if (at instanceof XSDouble && (d = (XSDouble)at).nan()) {
                return true;
            }
        }
        return at instanceof XSString || at instanceof XSUntypedAtomic;
    }
}

