/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.ast;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.internal.ast.AttrElemTest;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementTest
extends AttrElemTest {
    private final boolean qmark;
    private AnyType anyType = null;

    public ElementTest(QName name, boolean wild, QName type, boolean qmark) {
        super(name, wild, type);
        this.qmark = qmark;
    }

    public ElementTest(QName name, boolean wild, QName type) {
        super(name, wild, type);
        this.qmark = false;
    }

    public ElementTest(QName name, boolean wild) {
        super(name, wild);
        this.qmark = false;
    }

    public ElementTest() {
        this.qmark = false;
    }

    public boolean qmark() {
        return this.qmark;
    }

    @Override
    public AnyType createTestType(ResultSequence rs, StaticContext sc) {
        if (this.name() == null && !this.wild()) {
            return new ElementType();
        }
        Item at = rs.first();
        if (!(at instanceof NodeType)) {
            return new ElementType();
        }
        return this.createElementType(at, sc);
    }

    private AnyType createElementType(Item at, StaticContext sc) {
        this.anyType = new ElementType();
        NodeType nodeType = (NodeType)at;
        Node node = nodeType.node_value();
        Document doc = null;
        doc = node.getNodeType() == 9 ? (Document)node : nodeType.node_value().getOwnerDocument();
        NodeList nodeList = null;
        nodeList = !this.wild() ? doc.getElementsByTagNameNS(this.name().namespace(), this.name().local()) : new SingleItemNodeListImpl(node);
        if (nodeList.getLength() > 0) {
            this.anyType = this.createElementForXSDType(nodeList, sc);
        }
        return this.anyType;
    }

    private AnyType createElementForXSDType(NodeList nodeList, StaticContext sc) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            TypeModel typeModel = sc.getTypeModel();
            TypeDefinition typedef = typeModel.getType(element);
            if (this.type() == null || typedef == null) {
                this.anyType = new ElementType(element, typeModel);
                break;
            }
            if (!typedef.derivedFrom(this.type().namespace(), this.type().local(), this.getDerviationTypes())) continue;
            this.anyType = new ElementType(element, typeModel);
            break;
        }
        return this.anyType;
    }

    @Override
    public boolean isWild() {
        return this.wild();
    }

    public Class<ElementType> getXDMClassType() {
        return ElementType.class;
    }

    @Override
    public Object accept(XPathVisitor v) {
        return v.visit(this);
    }

    private static class SingleItemNodeListImpl
    implements NodeList {
        private final Node node;

        public SingleItemNodeListImpl(Node node) {
            this.node = node;
        }

        @Override
        public Node item(int index) {
            return this.node;
        }

        @Override
        public int getLength() {
            if (this.node != null) {
                return 1;
            }
            return 0;
        }
    }
}

