/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.ast;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.internal.ast.AttrElemTest;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.AttrType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AttributeTest
extends AttrElemTest {
    private AnyType anyType = null;

    public AttributeTest(QName name, boolean wild, QName type) {
        super(name, wild, type);
    }

    public AttributeTest(QName name, boolean wild) {
        super(name, wild);
    }

    public AttributeTest() {
    }

    @Override
    public AnyType createTestType(ResultSequence rs, StaticContext sc) {
        if (this.name() == null && !this.wild()) {
            return new AttrType();
        }
        Item at = rs.first();
        if (!(at instanceof NodeType)) {
            return new AttrType();
        }
        return this.createAttrType(at, sc);
    }

    private AnyType createAttrType(Item at, StaticContext sc) {
        this.anyType = new AttrType();
        NodeType nodeType = (NodeType)at;
        Node node = nodeType.node_value();
        if (node == null) {
            return this.anyType;
        }
        String nodeName = node.getLocalName();
        if (this.wild()) {
            if (this.type() != null) {
                this.anyType = this.createAttrForXSDType(node, sc);
            }
        } else if (nodeName.equals(this.name().local())) {
            this.anyType = this.type() != null ? this.createAttrForXSDType(node, sc) : new AttrType((Attr)node, sc.getTypeModel());
        }
        return this.anyType;
    }

    private AnyType createAttrForXSDType(Node node, StaticContext sc) {
        Attr attr = (Attr)node;
        TypeModel typeModel = sc.getTypeModel();
        TypeDefinition typedef = typeModel.getType(attr);
        if (typedef != null) {
            if (typedef.derivedFrom(this.type().namespace(), this.type().local(), this.getDerviationTypes())) {
                this.anyType = new AttrType(attr, sc.getTypeModel());
            }
        } else {
            this.anyType = new AttrType(attr, sc.getTypeModel());
        }
        return this.anyType;
    }

    @Override
    public boolean isWild() {
        return this.wild();
    }

    public Class<AttrType> getXDMClassType() {
        return AttrType.class;
    }

    @Override
    public Object accept(XPathVisitor v) {
        return v.visit(this);
    }
}

