/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal;

import info.fingo.xactus.api.CollationProvider;
import info.fingo.xactus.api.Function;
import info.fingo.xactus.api.FunctionLibrary;
import info.fingo.xactus.api.StaticVariableResolver;
import info.fingo.xactus.api.typesystem.ItemType;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.DynamicContext;
import info.fingo.xactus.processor.StaticContext;
import info.fingo.xactus.processor.internal.DefaultStaticContext;
import info.fingo.xactus.processor.internal.types.NodeItemTypeImpl;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.SimpleAtomicItemTypeImpl;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class StaticContextAdapter
implements info.fingo.xactus.api.StaticContext {
    private final StaticContext sc;

    public StaticContextAdapter(StaticContext sc) {
        this.sc = sc;
    }

    @Override
    public boolean isXPath1Compatible() {
        return this.sc.xpath1_compatible();
    }

    @Override
    public StaticVariableResolver getInScopeVariables() {
        return new StaticVariableResolver(){

            @Override
            public boolean isVariablePresent(javax.xml.namespace.QName name) {
                return StaticContextAdapter.this.sc.variable_exists(StaticContextAdapter.this.qn(name));
            }

            @Override
            public ItemType getVariableType(javax.xml.namespace.QName name) {
                return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE);
            }
        };
    }

    private QName qn(javax.xml.namespace.QName name) {
        return new QName(name);
    }

    @Override
    public TypeDefinition getInitialContextType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public Map<String, FunctionLibrary> getFunctionLibraries() {
        if (this.sc instanceof DefaultStaticContext) {
            DefaultStaticContext dsc = (DefaultStaticContext)this.sc;
            return dsc.get_function_libraries();
        }
        return Collections.emptyMap();
    }

    @Override
    public CollationProvider getCollationProvider() {
        if (this.sc instanceof DynamicContext) {
            final DynamicContext dc = (DynamicContext)this.sc;
            return new CollationProvider(){

                @Override
                public String getDefaultCollation() {
                    return dc.default_collation_name();
                }

                public Comparator getCollation(String name) {
                    return dc.get_collation(name);
                }
            };
        }
        return new CollationProvider(){

            @Override
            public String getDefaultCollation() {
                return null;
            }

            public Comparator getCollation(String name) {
                return null;
            }
        };
    }

    @Override
    public URI getBaseUri() {
        try {
            return new URI(this.sc.base_uri().getStringValue());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            public Iterator getPrefixes(String arg0) {
                return Collections.emptyList().iterator();
            }

            @Override
            public String getPrefix(String arg0) {
                return "x";
            }

            @Override
            public String getNamespaceURI(String prefix) {
                String ns = StaticContextAdapter.this.sc.resolve_prefix(prefix);
                return ns != null ? ns : "";
            }
        };
    }

    @Override
    public String getDefaultNamespace() {
        return this.sc.default_namespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.sc.default_function_namespace();
    }

    @Override
    public TypeModel getTypeModel() {
        return this.sc.getTypeModel(null);
    }

    @Override
    public Function resolveFunction(javax.xml.namespace.QName name, int arity) {
        if (this.sc.function_exists(new QName(name), arity) && this.sc instanceof DefaultStaticContext) {
            DefaultStaticContext dc = (DefaultStaticContext)this.sc;
            return dc.function(new QName(name), arity);
        }
        throw new IllegalArgumentException("Function not found " + name);
    }

    @Override
    public TypeDefinition getCollectionType(String collectionName) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public TypeDefinition getDefaultCollectionType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public ItemType getDocumentType(URI documentUri) {
        return new NodeItemTypeImpl(0, 9);
    }
}

