/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal;

import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.ast.ItemType;
import info.fingo.xactus.processor.internal.ast.KindTest;
import info.fingo.xactus.processor.internal.ast.SequenceType;
import info.fingo.xactus.processor.internal.function.ConstructorFL;
import info.fingo.xactus.processor.internal.function.FunctionLibrary;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import java.util.Map;
import org.w3c.dom.Node;

public class SeqType {
    public static final int OCC_NONE = 0;
    public static final int OCC_STAR = 1;
    public static final int OCC_PLUS = 2;
    public static final int OCC_QMARK = 3;
    public static final int OCC_EMPTY = 4;
    public static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final QName ANY_ATOMIC_TYPE = new QName("xs", "anyAtomicType", "http://www.w3.org/2001/XMLSchema");
    private transient AnyType anytype = null;
    private transient int occ;
    private transient Class typeClass = null;
    private transient QName nodeName = null;
    private transient boolean wild = false;

    public SeqType(AnyType t, int occ) {
        this.anytype = t;
        this.occ = occ;
        this.typeClass = t != null ? t.getClass() : null;
    }

    public SeqType(int occ) {
        this((AnyType)null, occ);
        this.typeClass = NodeType.class;
    }

    public SeqType(Class type_class, int occ) {
        this((AnyType)null, occ);
        this.typeClass = type_class;
    }

    public SeqType(SequenceType st, StaticContext sc, ResultSequence rs) {
        this.occ = SeqType.mapSequenceTypeOccurrence(st.occurrence());
        ItemType item = st.item_type();
        KindTest ktest = null;
        switch (item.type()) {
            case 0: {
                this.typeClass = AnyType.class;
                return;
            }
            case 1: {
                AnyAtomicType aat = this.make_atomic(sc, item.qname());
                assert (aat != null);
                this.anytype = aat;
                this.typeClass = item.qname().equals(ANY_ATOMIC_TYPE) ? AnyAtomicType.class : this.anytype.getClass();
                return;
            }
            case 2: {
                ktest = item.kind_test();
            }
        }
        if (ktest == null) {
            return;
        }
        this.typeClass = ktest.getXDMClassType();
        this.anytype = ktest.createTestType(rs, sc);
        this.nodeName = ktest.name();
        this.wild = ktest.isWild();
    }

    private AnyAtomicType make_atomic(StaticContext sc, QName qname) {
        String ns = qname.namespace();
        Map<String, info.fingo.xactus.api.FunctionLibrary> functionLibraries = sc.getFunctionLibraries();
        if (!functionLibraries.containsKey(ns)) {
            return null;
        }
        FunctionLibrary fl = (FunctionLibrary)functionLibraries.get(ns);
        if (!(fl instanceof ConstructorFL)) {
            return null;
        }
        ConstructorFL cfl = (ConstructorFL)fl;
        return cfl.atomic_type(qname);
    }

    public static int mapSequenceTypeOccurrence(int occurrence) {
        switch (occurrence) {
            case 0: {
                return 4;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        assert (false);
        return 0;
    }

    public SeqType(AnyType t) {
        this(t, 0);
    }

    public int occurence() {
        return this.occ;
    }

    public AnyType type() {
        return this.anytype;
    }

    public ResultSequence match(ResultSequence args) throws DynamicError {
        int occurrence = this.occurence();
        if (occurrence == 4 && !args.empty()) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        int arg_count = 0;
        for (AnyType arg : args) {
            if (!this.typeClass.isInstance(arg)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            if (this.anytype != null && (this.nodeName != null || this.wild) && arg instanceof NodeType) {
                NodeType nodeType = (NodeType)arg;
                Node node = nodeType.node_value();
                Node lnode = ((NodeType)this.anytype).node_value();
                if (lnode == null || !lnode.isEqualNode(node)) continue;
            }
            ++arg_count;
        }
        switch (occurrence) {
            case 0: {
                if (arg_count == true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 2: {
                if (arg_count != 0) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            case 1: {
                break;
            }
            case 3: {
                if (arg_count <= true) break;
                throw new DynamicError(TypeError.invalid_type(null));
            }
            default: {
                assert (false);
                break;
            }
        }
        return args;
    }
}

