/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal;

import info.fingo.xactus.processor.StaticError;
import info.fingo.xactus.processor.XPathParserException;
import info.fingo.xactus.processor.ast.XPath;
import info.fingo.xactus.processor.internal.CupError;
import info.fingo.xactus.processor.internal.DefaultVisitor;
import info.fingo.xactus.processor.internal.JFlexError;
import info.fingo.xactus.processor.internal.XPathCup;
import info.fingo.xactus.processor.internal.XPathFlex;
import info.fingo.xactus.processor.internal.ast.XPathExpr;
import java.io.StringReader;
import java.text.StringCharacterIterator;
import java_cup.runtime.Symbol;

public class InternalXPathParser {
    private static boolean containsInvalidSurrogatePairs(String toTest) {
        StringCharacterIterator iterator = new StringCharacterIterator(toTest);
        char ch = iterator.first();
        while (ch != '\uffff') {
            if (Character.isLowSurrogate(ch)) {
                return true;
            }
            if (Character.isHighSurrogate(ch) && !Character.isLowSurrogate(iterator.next())) {
                return true;
            }
            ch = iterator.next();
        }
        return false;
    }

    public XPath parse(String xpath, boolean isRootlessAccess) throws XPathParserException {
        if (InternalXPathParser.containsInvalidSurrogatePairs(xpath)) {
            throw new XPathParserException("Invalid surrogate pairs detected in XPath expression.");
        }
        XPathFlex lexer2 = new XPathFlex(new StringReader(xpath));
        try {
            XPathCup p = new XPathCup(lexer2);
            Symbol res = p.parse();
            XPath xPath2 = (XPath)res.value;
            if (isRootlessAccess) {
                xPath2.accept(new DefaultVisitor(){

                    @Override
                    public Object visit(XPathExpr e) {
                        if (e.slashes() > 0) {
                            throw new XPathParserException("Access to root node is not allowed (set by caller)");
                        }
                        do {
                            e.expr().accept(this);
                        } while ((e = e.next()) != null);
                        return null;
                    }
                });
            }
            return xPath2;
        }
        catch (JFlexError e) {
            throw new XPathParserException("JFlex lexer error: " + e.reason());
        }
        catch (CupError e) {
            throw new XPathParserException("CUP parser error: " + e.reason());
        }
        catch (StaticError e) {
            throw new XPathParserException(e.code(), e.getMessage());
        }
        catch (Exception e) {
            throw new XPathParserException(e.getMessage());
        }
    }
}

