/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal;

import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.processor.internal.ForwardAxis;
import info.fingo.xactus.processor.internal.types.DocType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.NodeType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildAxis
extends ForwardAxis {
    @Override
    public void iterate(NodeType node, ResultBuffer copyInto, Node limitNode) {
        this.addChildren(node, copyInto, false);
    }

    protected void addChildren(NodeType node, ResultBuffer copyInto, boolean recurse) {
        NodeList nl = null;
        if (node instanceof DocType) {
            nl = ((DocType)node).value().getChildNodes();
        }
        if (node instanceof ElementType) {
            nl = ((ElementType)node).value().getChildNodes();
        }
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node dnode = nl.item(i);
                NodeType n = NodeType.dom_to_xpath(dnode, node.getTypeModel());
                if (n == null) continue;
                copyInto.add(n);
                if (!recurse) continue;
                this.addChildren(n, copyInto, recurse);
            }
        }
    }

    @Override
    public String name() {
        return "child";
    }
}

