/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Function;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.DynamicContext;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.Evaluator;
import info.fingo.xactus.processor.ResultSequence;
import info.fingo.xactus.processor.XPathException;
import info.fingo.xactus.processor.ast.XPath;
import info.fingo.xactus.processor.internal.DescendantOrSelfAxis;
import info.fingo.xactus.processor.internal.DynamicContextAdapter;
import info.fingo.xactus.processor.internal.Focus;
import info.fingo.xactus.processor.internal.ForwardAxis;
import info.fingo.xactus.processor.internal.ParentAxis;
import info.fingo.xactus.processor.internal.ReverseAxis;
import info.fingo.xactus.processor.internal.SelfAxis;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.StaticContextAdapter;
import info.fingo.xactus.processor.internal.StaticTypeNameError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.ast.AddExpr;
import info.fingo.xactus.processor.internal.ast.AndExpr;
import info.fingo.xactus.processor.internal.ast.AnyKindTest;
import info.fingo.xactus.processor.internal.ast.AttributeTest;
import info.fingo.xactus.processor.internal.ast.AxisStep;
import info.fingo.xactus.processor.internal.ast.BinExpr;
import info.fingo.xactus.processor.internal.ast.CastExpr;
import info.fingo.xactus.processor.internal.ast.CastableExpr;
import info.fingo.xactus.processor.internal.ast.CmpExpr;
import info.fingo.xactus.processor.internal.ast.CntxItemExpr;
import info.fingo.xactus.processor.internal.ast.CommentTest;
import info.fingo.xactus.processor.internal.ast.DecimalLiteral;
import info.fingo.xactus.processor.internal.ast.DivExpr;
import info.fingo.xactus.processor.internal.ast.DocumentTest;
import info.fingo.xactus.processor.internal.ast.DoubleLiteral;
import info.fingo.xactus.processor.internal.ast.ElementTest;
import info.fingo.xactus.processor.internal.ast.ExceptExpr;
import info.fingo.xactus.processor.internal.ast.Expr;
import info.fingo.xactus.processor.internal.ast.FilterExpr;
import info.fingo.xactus.processor.internal.ast.ForExpr;
import info.fingo.xactus.processor.internal.ast.ForwardStep;
import info.fingo.xactus.processor.internal.ast.FunctionCall;
import info.fingo.xactus.processor.internal.ast.IDivExpr;
import info.fingo.xactus.processor.internal.ast.IfExpr;
import info.fingo.xactus.processor.internal.ast.InstOfExpr;
import info.fingo.xactus.processor.internal.ast.IntegerLiteral;
import info.fingo.xactus.processor.internal.ast.IntersectExpr;
import info.fingo.xactus.processor.internal.ast.ItemType;
import info.fingo.xactus.processor.internal.ast.MinusExpr;
import info.fingo.xactus.processor.internal.ast.ModExpr;
import info.fingo.xactus.processor.internal.ast.MulExpr;
import info.fingo.xactus.processor.internal.ast.NameTest;
import info.fingo.xactus.processor.internal.ast.OrExpr;
import info.fingo.xactus.processor.internal.ast.PITest;
import info.fingo.xactus.processor.internal.ast.ParExpr;
import info.fingo.xactus.processor.internal.ast.PipeExpr;
import info.fingo.xactus.processor.internal.ast.PlusExpr;
import info.fingo.xactus.processor.internal.ast.QuantifiedExpr;
import info.fingo.xactus.processor.internal.ast.RangeExpr;
import info.fingo.xactus.processor.internal.ast.ReverseStep;
import info.fingo.xactus.processor.internal.ast.SchemaAttrTest;
import info.fingo.xactus.processor.internal.ast.SchemaElemTest;
import info.fingo.xactus.processor.internal.ast.SequenceType;
import info.fingo.xactus.processor.internal.ast.SingleType;
import info.fingo.xactus.processor.internal.ast.StepExpr;
import info.fingo.xactus.processor.internal.ast.StringLiteral;
import info.fingo.xactus.processor.internal.ast.SubExpr;
import info.fingo.xactus.processor.internal.ast.TextTest;
import info.fingo.xactus.processor.internal.ast.TreatAsExpr;
import info.fingo.xactus.processor.internal.ast.UnionExpr;
import info.fingo.xactus.processor.internal.ast.VarExprPair;
import info.fingo.xactus.processor.internal.ast.VarRef;
import info.fingo.xactus.processor.internal.ast.XPathExpr;
import info.fingo.xactus.processor.internal.ast.XPathNode;
import info.fingo.xactus.processor.internal.ast.XPathVisitor;
import info.fingo.xactus.processor.internal.function.ConstructorFL;
import info.fingo.xactus.processor.internal.function.FnBoolean;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.function.FnRoot;
import info.fingo.xactus.processor.internal.function.FsDiv;
import info.fingo.xactus.processor.internal.function.FsEq;
import info.fingo.xactus.processor.internal.function.FsGe;
import info.fingo.xactus.processor.internal.function.FsGt;
import info.fingo.xactus.processor.internal.function.FsIDiv;
import info.fingo.xactus.processor.internal.function.FsLe;
import info.fingo.xactus.processor.internal.function.FsLt;
import info.fingo.xactus.processor.internal.function.FsMinus;
import info.fingo.xactus.processor.internal.function.FsMod;
import info.fingo.xactus.processor.internal.function.FsNe;
import info.fingo.xactus.processor.internal.function.FsPlus;
import info.fingo.xactus.processor.internal.function.FsTimes;
import info.fingo.xactus.processor.internal.function.FunctionLibrary;
import info.fingo.xactus.processor.internal.function.OpExcept;
import info.fingo.xactus.processor.internal.function.OpIntersect;
import info.fingo.xactus.processor.internal.function.OpTo;
import info.fingo.xactus.processor.internal.function.OpUnion;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.AttrType;
import info.fingo.xactus.processor.internal.types.CommentType;
import info.fingo.xactus.processor.internal.types.DocType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.PIType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.TextType;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import info.fingo.xactus.processor.util.ResultSequenceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultEvaluator
implements XPathVisitor,
Evaluator {
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final QName ANY_ATOMIC_TYPE = new QName("xs", "anyAtomicType", "http://www.w3.org/2001/XMLSchema");
    private final StaticContext _sc;
    private final info.fingo.xactus.api.DynamicContext _dc;
    private final EvaluationContext _ec;
    private Object _param = null;
    private Focus _focus = new Focus(ResultBuffer.EMPTY);
    private VariableScope _innerScope = null;

    public static XSBoolean effective_boolean_value(info.fingo.xactus.api.ResultSequence rs) {
        return FnBoolean.fn_boolean(rs);
    }

    public static info.fingo.xactus.api.ResultSequence contextResultSequence(TypeModel typeModel, Object ... contextItems) {
        ResultBuffer rs = new ResultBuffer();
        for (Object obj : contextItems) {
            if (obj instanceof Node) {
                rs.add(NodeType.dom_to_xpath((Node)obj, typeModel));
                continue;
            }
            if (obj instanceof Item) {
                rs.add((Item)obj);
                continue;
            }
            if (obj == null) continue;
            throw new XPathException("unsupported context item: " + obj.getClass().getSimpleName());
        }
        return rs.getSequence();
    }

    public DefaultEvaluator(DynamicContext dynamicContext, Document doc) {
        this(new StaticContextAdapter(dynamicContext), new DynamicContextAdapter(dynamicContext));
        info.fingo.xactus.api.ResultSequence focusSequence = doc != null ? new DocType(doc, this._sc.getTypeModel()) : ResultBuffer.EMPTY;
        this.set_focus(new Focus(focusSequence));
        dynamicContext.set_focus(this.focus());
    }

    public DefaultEvaluator(StaticContext staticContext, info.fingo.xactus.api.DynamicContext dynamicContext, Object[] contextItems) {
        this(staticContext, dynamicContext, DefaultEvaluator.contextResultSequence(staticContext.getTypeModel(), contextItems));
    }

    public DefaultEvaluator(StaticContext staticContext, info.fingo.xactus.api.DynamicContext dynamicContext, info.fingo.xactus.api.ResultSequence contextRS) {
        this(staticContext, dynamicContext);
        this.set_focus(new Focus(contextRS));
    }

    private DefaultEvaluator(StaticContext staticContext, info.fingo.xactus.api.DynamicContext dynamicContext) {
        this._sc = staticContext;
        this._dc = dynamicContext;
        this._ec = new EvaluationContext(){

            @Override
            public info.fingo.xactus.api.DynamicContext getDynamicContext() {
                return DefaultEvaluator.this._dc;
            }

            @Override
            public AnyType getContextItem() {
                return DefaultEvaluator.this._focus.context_item();
            }

            @Override
            public int getContextPosition() {
                return DefaultEvaluator.this._focus.position();
            }

            @Override
            public int getLastPosition() {
                return DefaultEvaluator.this._focus.last();
            }

            @Override
            public StaticContext getStaticContext() {
                return DefaultEvaluator.this._sc;
            }
        };
    }

    Focus focus() {
        return this._focus;
    }

    void set_focus(Focus f) {
        this._focus = f;
    }

    private void popScope() {
        if (this._innerScope == null) {
            throw new IllegalStateException("Unmatched scope pop");
        }
        this._innerScope = this._innerScope.nextScope;
    }

    private void pushScope(QName var, info.fingo.xactus.api.ResultSequence value) {
        this._innerScope = new VariableScope(var, value, this._innerScope);
    }

    private boolean derivesFrom(NodeType at, QName et) {
        TypeDefinition td = this._sc.getTypeModel().getType(at.node_value());
        short method = 3;
        return td != null && td.derivedFrom(et.namespace(), et.local(), method);
    }

    private boolean derivesFrom(NodeType at, TypeDefinition td) {
        TypeDefinition nodeTd = this._sc.getTypeModel().getType(at.node_value());
        short method = 3;
        return nodeTd != null && nodeTd.derivedFromType(td, method);
    }

    private info.fingo.xactus.api.ResultSequence getVariable(QName name) {
        VariableScope scope = this._innerScope;
        while (scope != null) {
            if (name.equals(scope.name)) {
                return scope.value;
            }
            scope = scope.nextScope;
        }
        return this._dc.getVariable(name.asQName());
    }

    private AnyAtomicType makeAtomic(QName name) {
        FunctionLibrary fl = (FunctionLibrary)this._sc.getFunctionLibraries().get(name.namespace());
        if (fl instanceof ConstructorFL) {
            ConstructorFL cfl = (ConstructorFL)fl;
            return cfl.atomic_type(name);
        }
        return null;
    }

    @Override
    public ResultSequence evaluate(XPathNode node) {
        return ResultSequenceUtil.newToOld(this.evaluate2(node));
    }

    public info.fingo.xactus.api.ResultSequence evaluate2(XPathNode node) {
        return (info.fingo.xactus.api.ResultSequence)node.accept(this);
    }

    private info.fingo.xactus.api.ResultSequence do_expr(Iterable<Expr> exps) {
        info.fingo.xactus.api.ResultSequence rs = null;
        ResultBuffer buffer = null;
        for (Expr e : exps) {
            info.fingo.xactus.api.ResultSequence result = (info.fingo.xactus.api.ResultSequence)e.accept(this);
            if (rs == null && buffer == null) {
                rs = result;
                continue;
            }
            if (buffer == null) {
                buffer = new ResultBuffer();
                buffer.concat(rs);
                rs = null;
            }
            buffer.concat(result);
        }
        if (buffer != null) {
            return buffer.getSequence();
        }
        if (rs != null) {
            return rs;
        }
        return ResultBuffer.EMPTY;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(XPath xp) {
        info.fingo.xactus.api.ResultSequence rs = this.do_expr(xp);
        return rs;
    }

    private void do_for_each(ListIterator<VarExprPair> iter, Expr finalexpr, ResultBuffer destination) {
        if (iter.hasNext()) {
            VarExprPair ve = iter.next();
            info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)ve.expr().accept(this);
            if (rs.empty()) {
                iter.previous();
                return;
            }
            QName varname = ve.varname();
            for (AnyType item : rs) {
                this.pushScope(varname, item);
                this.do_for_each(iter, finalexpr, destination);
                this.popScope();
            }
            iter.previous();
        } else {
            destination.concat((info.fingo.xactus.api.ResultSequence)finalexpr.accept(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSBoolean do_for_all(ListIterator<VarExprPair> iter, Expr finalexpr) {
        if (iter.hasNext()) {
            VarExprPair ve = iter.next();
            info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)ve.expr().accept(this);
            QName varname = ve.varname();
            try {
                for (AnyType item : rs) {
                    this.pushScope(varname, item);
                    XSBoolean effbool = this.do_for_all(iter, finalexpr);
                    this.popScope();
                    if (effbool.value()) continue;
                    XSBoolean xSBoolean = XSBoolean.FALSE;
                    return xSBoolean;
                }
            }
            finally {
                iter.previous();
            }
            return XSBoolean.TRUE;
        }
        return DefaultEvaluator.effective_boolean_value((info.fingo.xactus.api.ResultSequence)finalexpr.accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSBoolean do_exists(ListIterator<VarExprPair> iter, Expr finalexpr) {
        if (iter.hasNext()) {
            VarExprPair ve = iter.next();
            info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)ve.expr().accept(this);
            QName varname = ve.varname();
            try {
                for (AnyType item : rs) {
                    this.pushScope(varname, item);
                    XSBoolean effbool = this.do_exists(iter, finalexpr);
                    this.popScope();
                    if (!effbool.value()) continue;
                    XSBoolean xSBoolean = XSBoolean.TRUE;
                    return xSBoolean;
                }
            }
            finally {
                iter.previous();
            }
            return XSBoolean.FALSE;
        }
        return DefaultEvaluator.effective_boolean_value((info.fingo.xactus.api.ResultSequence)finalexpr.accept(this));
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ForExpr fex) {
        ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>(fex.ve_pairs());
        ResultBuffer rb = new ResultBuffer();
        this.do_for_each(pairs.listIterator(), fex.expr(), rb);
        return rb.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(QuantifiedExpr qex) {
        ArrayList<VarExprPair> pairs = new ArrayList<VarExprPair>(qex.ve_pairs());
        switch (qex.type()) {
            case 0: {
                return this.do_exists(pairs.listIterator(), qex.expr());
            }
            case 1: {
                return this.do_for_all(pairs.listIterator(), qex.expr());
            }
        }
        assert (false);
        return null;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(IfExpr ifex) {
        info.fingo.xactus.api.ResultSequence test_res = this.do_expr(ifex);
        XSBoolean res = DefaultEvaluator.effective_boolean_value(test_res);
        if (res.value()) {
            return (info.fingo.xactus.api.ResultSequence)ifex.then_clause().accept(this);
        }
        return (info.fingo.xactus.api.ResultSequence)ifex.else_clause().accept(this);
    }

    private boolean[] do_logic_exp(BinExpr e) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(e);
        info.fingo.xactus.api.ResultSequence one = args.get(0);
        info.fingo.xactus.api.ResultSequence two = args.get(1);
        boolean oneb = DefaultEvaluator.effective_boolean_value(one).value();
        boolean twob = DefaultEvaluator.effective_boolean_value(two).value();
        boolean[] res = new boolean[]{oneb, twob};
        return res;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(OrExpr orex) {
        boolean[] res = this.do_logic_exp(orex);
        return XSBoolean.valueOf(res[0] || res[1]);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(AndExpr andex) {
        boolean[] res = this.do_logic_exp(andex);
        return XSBoolean.valueOf(res[0] && res[1]);
    }

    private info.fingo.xactus.api.ResultSequence node_cmp(int type, List<info.fingo.xactus.api.ResultSequence> args) {
        boolean answer;
        assert (args.size() == 2);
        info.fingo.xactus.api.ResultSequence one = args.get(0);
        info.fingo.xactus.api.ResultSequence two = args.get(1);
        int size_one = one.size();
        int size_two = two.size();
        if (size_one > 1 || size_two > 1) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        if (size_one == 0 || size_two == 0) {
            return ResultBuffer.EMPTY;
        }
        Item at_one = one.item(0);
        Item at_two = two.item(0);
        if (!(at_one instanceof NodeType) || !(at_two instanceof NodeType)) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        NodeType nt_one = (NodeType)at_one;
        NodeType nt_two = (NodeType)at_two;
        switch (type) {
            case 12: {
                answer = nt_one.node_value() == nt_two.node_value();
                break;
            }
            case 13: {
                answer = nt_one.before(nt_two);
                break;
            }
            case 14: {
                answer = nt_one.after(nt_two);
                break;
            }
            default: {
                throw new XPathException("unknown type: " + type);
            }
        }
        return XSBoolean.valueOf(answer);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(CmpExpr cmpex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(cmpex);
        switch (cmpex.type()) {
            case 6: {
                return FsEq.fs_eq_value(args, this._dc);
            }
            case 7: {
                return FsNe.fs_ne_value(args, this._dc);
            }
            case 10: {
                return FsGt.fs_gt_value(args, this._dc);
            }
            case 8: {
                return FsLt.fs_lt_value(args, this._dc);
            }
            case 11: {
                return FsGe.fs_ge_value(args, this._dc);
            }
            case 9: {
                return FsLe.fs_le_value(args, this._dc);
            }
            case 0: {
                return FsEq.fs_eq_general(args, this._dc);
            }
            case 1: {
                return FsNe.fs_ne_general(args, this._dc);
            }
            case 4: {
                return FsGt.fs_gt_general(args, this._dc);
            }
            case 2: {
                return FsLt.fs_lt_general(args, this._dc);
            }
            case 5: {
                return FsGe.fs_ge_general(args, this._dc);
            }
            case 3: {
                return FsLe.fs_le_general(args, this._dc);
            }
            case 12: 
            case 13: 
            case 14: {
                return this.node_cmp(cmpex.type(), args);
            }
        }
        throw new XPathException("unknown type: " + cmpex.type());
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(RangeExpr rex) {
        info.fingo.xactus.api.ResultSequence one = (info.fingo.xactus.api.ResultSequence)rex.left().accept(this);
        info.fingo.xactus.api.ResultSequence two = (info.fingo.xactus.api.ResultSequence)rex.right().accept(this);
        if (one.empty() || two.empty()) {
            return ResultBuffer.EMPTY;
        }
        List<info.fingo.xactus.api.ResultSequence> args = Arrays.asList(one, two);
        return OpTo.op_to(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(AddExpr addex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(addex);
        return FsPlus.fs_plus(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(SubExpr subex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(subex);
        return FsMinus.fs_minus(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(MulExpr mulex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(mulex);
        return FsTimes.fs_times(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(DivExpr mulex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(mulex);
        return FsDiv.fs_div(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(IDivExpr mulex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(mulex);
        return FsIDiv.fs_idiv(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ModExpr mulex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(mulex);
        return FsMod.fs_mod(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(UnionExpr unex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(unex);
        return OpUnion.op_union(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(PipeExpr pipex) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(pipex);
        return OpUnion.op_union(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(IntersectExpr iexpr) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(iexpr);
        return OpIntersect.op_intersect(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ExceptExpr eexpr) {
        List<info.fingo.xactus.api.ResultSequence> args = this.do_bin_args(eexpr);
        return OpExcept.op_except(args);
    }

    private List<info.fingo.xactus.api.ResultSequence> do_bin_args(BinExpr e) {
        info.fingo.xactus.api.ResultSequence one = (info.fingo.xactus.api.ResultSequence)e.left().accept(this);
        info.fingo.xactus.api.ResultSequence two = (info.fingo.xactus.api.ResultSequence)e.right().accept(this);
        return Arrays.asList(one, two);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(InstOfExpr ioexp) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)ioexp.left().accept(this);
        SequenceType seqt = (SequenceType)ioexp.right();
        return XSBoolean.valueOf(this.isInstanceOf(rs, seqt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstanceOf(info.fingo.xactus.api.ResultSequence rs, SequenceType seqt) {
        Object oldParam = this._param;
        try {
            this._param = new Pair(null, rs);
            int sequenceLength = rs.size();
            seqt.accept(this);
            rs = ((Pair)this._param)._two;
            int lengthAfter = rs.size();
            if (sequenceLength != lengthAfter) {
                boolean bl = false;
                return bl;
            }
            boolean bl = seqt.isLengthValid(sequenceLength);
            return bl;
        }
        finally {
            this._param = oldParam;
        }
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(TreatAsExpr taexp) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)taexp.left().accept(this);
        SequenceType seqt = (SequenceType)taexp.right();
        SeqType st = new SeqType(seqt, this._sc, rs);
        st.match(rs);
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(CastableExpr cexp) {
        boolean castable = false;
        try {
            CastExpr ce = new CastExpr((Expr)cexp.left(), (SingleType)cexp.right());
            this.visit(ce);
            castable = true;
        }
        catch (Throwable t) {
            castable = false;
        }
        return XSBoolean.valueOf(castable);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(CastExpr cexp) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)cexp.left().accept(this);
        SingleType st = (SingleType)cexp.right();
        if ((rs = FnData.atomize(rs)).size() > 1) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        if (rs.empty()) {
            if (st.qmark()) {
                return rs;
            }
            throw new DynamicError(TypeError.invalid_type(null));
        }
        AnyType at = (AnyType)rs.item(0);
        if (!(at instanceof AnyAtomicType)) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        AnyAtomicType aat = (AnyAtomicType)at;
        QName type = st.type();
        List<info.fingo.xactus.api.ResultSequence> args = Arrays.asList(aat);
        Function function = cexp.function();
        if (function == null) {
            function = this._sc.resolveFunction(type.asQName(), args.size());
            cexp.set_function(function);
        }
        if (function == null) {
            throw new DynamicError(TypeError.invalid_type(null));
        }
        return function.evaluate(args, this._ec);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(MinusExpr e) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.arg().accept(this);
        List<info.fingo.xactus.api.ResultSequence> args = Arrays.asList(rs);
        return FsMinus.fs_minus_unary(args);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(PlusExpr e) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.arg().accept(this);
        List<info.fingo.xactus.api.ResultSequence> args = Arrays.asList(rs);
        return FsPlus.fs_plus_unary(args);
    }

    private info.fingo.xactus.api.ResultSequence do_step(StepExpr se) {
        ResultBuffer rs = new ResultBuffer();
        LinkedList<info.fingo.xactus.api.ResultSequence> results = new LinkedList<info.fingo.xactus.api.ResultSequence>();
        int type = 0;
        Focus focus = this.focus();
        int original_pos = focus.position();
        do {
            results.add((info.fingo.xactus.api.ResultSequence)se.accept(this));
        } while (focus.advance_cp());
        focus.set_position(original_pos);
        boolean node_types = false;
        for (info.fingo.xactus.api.ResultSequence result : results) {
            block6: for (Item next : result) {
                AnyType item = (AnyType)next;
                if (type == 0) {
                    if (item instanceof AnyAtomicType) {
                        type = 1;
                    } else if (item instanceof NodeType) {
                        type = 2;
                    } else assert (false);
                }
                switch (type) {
                    case 1: {
                        if (!(item instanceof AnyAtomicType)) {
                            throw new DynamicError(TypeError.mixed_vals(null));
                        }
                        rs.add(item);
                        continue block6;
                    }
                    case 2: {
                        node_types = true;
                        if (!(item instanceof NodeType)) {
                            throw new DynamicError(TypeError.mixed_vals(null));
                        }
                        rs.add(item);
                        continue block6;
                    }
                }
                assert (false);
            }
        }
        if (node_types) {
            rs = NodeType.linarize(rs);
        }
        return rs.getSequence();
    }

    private info.fingo.xactus.api.ResultSequence root_self_node() {
        SelfAxis axis = new SelfAxis();
        ResultBuffer buffer = new ResultBuffer();
        axis.iterate((NodeType)this.focus().context_item(), buffer, this._dc.getLimitNode());
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(buffer.getSequence(), NodeType.class);
        List<info.fingo.xactus.api.ResultSequence> records = Arrays.asList(rs);
        return FnRoot.fn_root(records, this._ec);
    }

    private info.fingo.xactus.api.ResultSequence descendant_or_self_node(info.fingo.xactus.api.ResultSequence rs) {
        ResultBuffer res = new ResultBuffer();
        DescendantOrSelfAxis axis = new DescendantOrSelfAxis();
        for (NodeType item : rs) {
            axis.iterate(item, res, this._dc.getLimitNode());
        }
        return res.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(XPathExpr e) {
        info.fingo.xactus.api.ResultSequence rs = null;
        Focus original_focus = this.focus();
        for (XPathExpr xp = e; xp != null; xp = xp.next()) {
            StepExpr se = xp.expr();
            if (se != null) {
                if (rs != null) {
                    if (rs.size() == 0) break;
                    for (Item next : rs) {
                        AnyType item = (AnyType)next;
                        if (item instanceof NodeType) continue;
                        throw new DynamicError(TypeError.step_conatins_atoms(null));
                    }
                    if (xp.slashes() == 2 && (rs = this.descendant_or_self_node(rs)).size() == 0) break;
                    this.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                if (xp.slashes() == 1) {
                    rs = this.root_self_node();
                    this.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                if (xp.slashes() == 2) {
                    rs = this.root_self_node();
                    rs = this.descendant_or_self_node(rs);
                    this.set_focus(new Focus(rs));
                    rs = this.do_step(se);
                    continue;
                }
                rs = (info.fingo.xactus.api.ResultSequence)se.accept(this);
                continue;
            }
            assert (xp.slashes() == 1);
            rs = this.root_self_node();
        }
        this.set_focus(original_focus);
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ForwardStep e) {
        AnyType ci = this.focus().context_item();
        if (ci == null) {
            throw DynamicError.contextUndefined();
        }
        if (!(ci instanceof NodeType)) {
            throw new DynamicError(TypeError.ci_not_node(ci.string_type()));
        }
        NodeType cn = (NodeType)ci;
        ForwardAxis axis = e.iterator();
        ResultBuffer rb = new ResultBuffer();
        axis.iterate(cn, rb, this._dc.getLimitNode());
        Pair arg = new Pair(axis.principal_node_kind().string_type(), rb.getSequence());
        this._param = arg;
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.node_test().accept(this);
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ReverseStep e) {
        AnyType ci = this.focus().context_item();
        if (!(ci instanceof NodeType)) {
            throw new DynamicError(TypeError.ci_not_node(ci.string_type()));
        }
        NodeType cn = (NodeType)ci;
        ReverseAxis axis = e.iterator();
        ResultBuffer result = new ResultBuffer();
        if (e.axis() == 5) {
            new ParentAxis().iterate(cn, result, this._dc.getLimitNode());
            return result.getSequence();
        }
        assert (axis != null);
        axis.iterate(cn, result, null);
        Pair arg = new Pair(axis.principal_node_kind().string_type(), result.getSequence());
        this._param = arg;
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.node_test().accept(this);
        return rs;
    }

    private boolean name_test(NodeType node, QName name, String type) {
        if (node == null) {
            return false;
        }
        if (!type.equals(node.string_type())) {
            return false;
        }
        String test_prefix = name.prefix();
        if (test_prefix == null && type.equals("element")) {
            name = new QName(null, name.local());
            name.set_namespace(this._sc.getDefaultNamespace());
            if (name.namespace() != null && name.namespace().length() > 0) {
                test_prefix = "";
            }
        }
        QName node_name = node.node_name();
        assert (node_name != null);
        String node_namespace = node_name.namespace();
        String test_namespace = null;
        if (name.expanded()) {
            test_namespace = name.namespace();
        }
        if (test_prefix == null) {
            if (node_namespace != null) {
                return false;
            }
        } else if (!test_namespace.equals("*")) {
            if (node_namespace == null) {
                return false;
            }
            if (!node_namespace.equals(test_namespace)) {
                return false;
            }
        }
        if (name.local().equals("*")) {
            return true;
        }
        return name.local().equals(node_name.local());
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(NameTest e) {
        QName name = e.name();
        Pair arg = (Pair)this._param;
        String type = arg._one;
        info.fingo.xactus.api.ResultSequence rs = arg._two;
        ResultBuffer rb = new ResultBuffer();
        for (NodeType nt : rs) {
            if (!this.name_test(nt, name, type)) continue;
            rb.add(nt);
        }
        arg._two = rs = rb.getSequence();
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(VarRef e) {
        ResultBuffer rs = new ResultBuffer();
        info.fingo.xactus.api.ResultSequence var = this.getVariable(e.name());
        assert (var != null);
        if (var instanceof AnyType) {
            rs.add((AnyType)var);
        } else if (var instanceof info.fingo.xactus.api.ResultSequence) {
            rs.concat(var);
        }
        return rs.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(StringLiteral e) {
        return e.value();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(IntegerLiteral e) {
        return e.value();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(DoubleLiteral e) {
        return e.value();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(DecimalLiteral e) {
        ResultBuffer rs = new ResultBuffer();
        rs.add(e.value());
        return rs.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ParExpr e) {
        return this.do_expr(e);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(CntxItemExpr e) {
        ResultBuffer rs = new ResultBuffer();
        AnyType contextItem = this.focus().context_item();
        if (contextItem == null) {
            throw DynamicError.contextUndefined();
        }
        rs.add(contextItem);
        return rs.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(FunctionCall e) {
        ArrayList<info.fingo.xactus.api.ResultSequence> args = new ArrayList<info.fingo.xactus.api.ResultSequence>();
        for (Expr arg : e) {
            args.add((info.fingo.xactus.api.ResultSequence)arg.accept(this));
        }
        Function function = e.function();
        if (function == null) {
            function = this._sc.resolveFunction(e.name().asQName(), args.size());
            e.set_function(function);
        }
        return function.evaluate(args, this._ec);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(SingleType e) {
        return null;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(SequenceType e) {
        ItemType it = e.item_type();
        if (it != null) {
            it.accept(this);
        }
        return null;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ItemType e) {
        switch (e.type()) {
            case 0: {
                break;
            }
            case 1: {
                boolean ok = false;
                TypeModel model = this._sc.getTypeModel();
                if (model != null) {
                    boolean bl = ok = this._sc.getTypeModel().lookupType(e.qname().namespace(), e.qname().local()) != null;
                }
                if (!ok) {
                    boolean bl = ok = BuiltinTypeLibrary.BUILTIN_TYPES.lookupType(e.qname().namespace(), e.qname().local()) != null;
                }
                if (!ok) {
                    throw new StaticTypeNameError("Type not defined: " + e.qname().string());
                }
                info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
                ((Pair)this._param)._two = this.item_test(arg, e.qname());
                break;
            }
            case 2: {
                ((Pair)this._param)._two = (info.fingo.xactus.api.ResultSequence)e.kind_test().accept(this);
            }
        }
        return null;
    }

    private info.fingo.xactus.api.ResultSequence item_test(info.fingo.xactus.api.ResultSequence rs, QName qname) {
        ResultBuffer rb = new ResultBuffer();
        for (AnyType item : rs) {
            if (item instanceof NodeType) {
                NodeType node = (NodeType)item;
                if (!this.derivesFrom(node, qname)) continue;
                rb.add(node);
                continue;
            }
            if (qname.equals(ANY_ATOMIC_TYPE)) {
                rb.add(item);
                continue;
            }
            AnyAtomicType aat = this.makeAtomic(qname);
            if (!aat.getClass().isInstance(item)) continue;
            rb.add(item);
        }
        return rb.getSequence();
    }

    private info.fingo.xactus.api.ResultSequence kind_test(info.fingo.xactus.api.ResultSequence rs, Class<?> kind) {
        ResultBuffer rb = new ResultBuffer();
        for (Item item : rs) {
            if (!kind.isInstance(item)) continue;
            rb.add(item);
        }
        return rb.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(AnyKindTest e) {
        info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
        return this.kind_test(arg, NodeType.class);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(DocumentTest e) {
        info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
        int type = e.type();
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(arg, DocType.class);
        if (type == 0) {
            return rs;
        }
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            DocType doc = (DocType)i.next();
            int elem_count = 0;
            ElementType elem = null;
            NodeList children = doc.node_value().getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                if (++elem_count > 1) break;
                elem = new ElementType((Element)child, this._sc.getTypeModel());
            }
            if (elem_count != 1) {
                i.remove();
                continue;
            }
            assert (elem != null);
            info.fingo.xactus.api.ResultSequence res = new ResultBuffer.SingleResultSequence(elem);
            this._param = new Pair("element", res);
            res = null;
            if (type == 1) {
                res = (info.fingo.xactus.api.ResultSequence)e.elem_test().accept(this);
            } else if (type == 2) {
                res = (info.fingo.xactus.api.ResultSequence)e.schema_elem_test().accept(this);
            } else assert (false);
            if (res.size() == 1) continue;
            i.remove();
        }
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(TextTest e) {
        info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
        ((Pair)this._param)._two = this.kind_test(arg, TextType.class);
        return ((Pair)this._param)._two;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(CommentTest e) {
        info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
        return this.kind_test(arg, CommentType.class);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(PITest e) {
        info.fingo.xactus.api.ResultSequence arg = ((Pair)this._param)._two;
        String pit_arg = e.arg();
        if (pit_arg == null) {
            return this.kind_test(arg, PIType.class);
        }
        ResultBuffer rb = new ResultBuffer();
        for (AnyType item : arg) {
            PIType pi;
            if (!(item instanceof PIType) || !pit_arg.equals((pi = (PIType)item).value().getTarget())) continue;
            rb.add(pi);
        }
        ((Pair)this._param)._two = arg = rb.getSequence();
        return arg;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(AttributeTest e) {
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(((Pair)this._param)._two, AttrType.class);
        ResultBuffer rb = new ResultBuffer();
        QName name = e.name();
        QName type = e.type();
        for (NodeType node : rs) {
            if (name != null && !e.wild() && !this.name_test(node, name, "attribute") || type != null && !this.derivesFrom(node, type)) continue;
            rb.add(node);
        }
        ((Pair)this._param)._two = rb.getSequence();
        return ((Pair)this._param)._two;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(SchemaAttrTest e) {
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(((Pair)this._param)._two, AttrType.class);
        QName name = e.arg();
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            if (this.name_test((NodeType)i.next(), name, "attribute")) continue;
            i.remove();
        }
        TypeDefinition et = this._sc.getTypeModel().lookupAttributeDeclaration(name.namespace(), name.local());
        Iterator i2 = rs.iterator();
        while (i2.hasNext()) {
            NodeType node = (NodeType)i2.next();
            if (this.derivesFrom(node, et)) continue;
            i2.remove();
        }
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(ElementTest e) {
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(((Pair)this._param)._two, ElementType.class);
        ResultBuffer rb = new ResultBuffer();
        QName nameTest = e.name();
        QName typeTest = e.type();
        for (NodeType node : rs) {
            XSBoolean nilled;
            if (nameTest != null && !e.wild() && !this.name_test((ElementType)node, nameTest, "element") || typeTest != null && (!this.derivesFrom(node, typeTest) || !e.qmark() && (nilled = (XSBoolean)node.nilled().first()).value())) continue;
            rb.add(node);
        }
        ((Pair)this._param)._two = rb.getSequence();
        return ((Pair)this._param)._two;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(SchemaElemTest e) {
        info.fingo.xactus.api.ResultSequence rs = this.kind_test(((Pair)this._param)._two, ElementType.class);
        QName name = e.name();
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            if (this.name_test((ElementType)i.next(), name, "element")) continue;
            i.remove();
        }
        TypeDefinition et = this._sc.getTypeModel().lookupElementDeclaration(name.namespace(), name.local());
        Iterator i2 = rs.iterator();
        while (i2.hasNext()) {
            NodeType node = (NodeType)i2.next();
            if (!this.derivesFrom(node, et)) {
                i2.remove();
                continue;
            }
            XSBoolean nilled = (XSBoolean)node.nilled().first();
            if (!nilled.value()) continue;
            i2.remove();
        }
        return rs;
    }

    private boolean predicate_truth(info.fingo.xactus.api.ResultSequence rs) {
        AnyType at;
        if (rs.size() == 1 && (at = (AnyType)rs.item(0)) instanceof NumericType) {
            return FsEq.fs_eq_fast(at, new XSInteger(BigInteger.valueOf(this.focus().position())), this._dc);
        }
        XSBoolean ret = DefaultEvaluator.effective_boolean_value(rs);
        return ret.value();
    }

    private info.fingo.xactus.api.ResultSequence do_predicate(Collection<Expr> exprs) {
        FilterExpr fex;
        XPathExpr xpe;
        Expr expr;
        ResultBuffer rs = new ResultBuffer();
        Focus focus = this.focus();
        int original_cp = focus.position();
        if (exprs.size() == 1 && (expr = exprs.iterator().next()) instanceof XPathExpr && (xpe = (XPathExpr)expr).next() == null && xpe.slashes() == 0 && xpe.expr() instanceof FilterExpr && (fex = (FilterExpr)xpe.expr()).primary() instanceof IntegerLiteral) {
            int pos = ((IntegerLiteral)fex.primary()).value().int_value().intValue();
            if (pos <= focus.last() && pos > 0) {
                focus.set_position(pos);
                rs.add(focus.context_item());
            }
            focus.set_position(original_cp);
            return rs.getSequence();
        }
        do {
            info.fingo.xactus.api.ResultSequence res;
            if (!this.predicate_truth(res = this.do_expr(exprs))) continue;
            rs.add(this.focus().context_item());
        } while (focus.advance_cp());
        focus.set_position(original_cp);
        return rs.getSequence();
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(AxisStep e) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.step().accept(this);
        if (e.predicate_count() == 0) {
            return rs;
        }
        Focus original_focus = this.focus();
        for (Collection<Expr> coll : e) {
            if (rs.size() == 0) break;
            this.set_focus(new Focus(rs));
            rs = this.do_predicate(coll);
        }
        this.set_focus(original_focus);
        return rs;
    }

    @Override
    public info.fingo.xactus.api.ResultSequence visit(FilterExpr e) {
        info.fingo.xactus.api.ResultSequence rs = (info.fingo.xactus.api.ResultSequence)e.primary().accept(this);
        if (e.predicate_count() == 0) {
            return rs;
        }
        Focus original_focus = this.focus();
        for (Collection<Expr> i : e) {
            if (rs.size() == 0) break;
            this.set_focus(new Focus(rs));
            rs = this.do_predicate(i);
        }
        this.set_focus(original_focus);
        return rs;
    }

    class VariableScope {
        public final QName name;
        public final info.fingo.xactus.api.ResultSequence value;
        public final VariableScope nextScope;

        public VariableScope(QName name, info.fingo.xactus.api.ResultSequence value, VariableScope nextScope) {
            this.name = name;
            this.value = value;
            this.nextScope = nextScope;
        }
    }

    static class Pair {
        public String _one;
        public info.fingo.xactus.api.ResultSequence _two;

        public Pair(String o, info.fingo.xactus.api.ResultSequence t) {
            this._one = o;
            this._two = t;
        }
    }
}

