/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor;

import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.CollationProvider;
import info.fingo.xactus.processor.DOMLoaderException;
import info.fingo.xactus.processor.DynamicContext;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.ResultSequence;
import info.fingo.xactus.processor.XercesLoader;
import info.fingo.xactus.processor.internal.DefaultStaticContext;
import info.fingo.xactus.processor.internal.Focus;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.function.FunctionLibrary;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.DocType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.xerces.XercesTypeModel;
import info.fingo.xactus.processor.util.ResultSequenceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultDynamicContext
extends DefaultStaticContext
implements DynamicContext {
    private Focus _focus = null;
    private XSDuration _tz = new XSDayTimeDuration(0, 5, 0, 0.0, true);
    private Map _loaded_documents = new HashMap();
    private GregorianCalendar _current_date_time;
    private String _default_collation_name = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private CollationProvider _collation_provider;
    private static Comparator CODEPOINT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareTo((String)o2);
        }
    };

    public DefaultDynamicContext(XSModel schema, Document doc) {
        this(new XercesTypeModel(schema));
    }

    public DefaultDynamicContext(TypeModel schema) {
        super(schema);
    }

    @Override
    public XSDuration tz() {
        return this._tz;
    }

    @Override
    public GregorianCalendar current_date_time() {
        if (this._current_date_time == null) {
            this._current_date_time = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return this._current_date_time;
    }

    @Override
    public void set_focus(Focus f) {
        this._focus = f;
    }

    @Override
    public Focus focus() {
        return this._focus;
    }

    @Override
    public AnyType context_item() {
        return this._focus.context_item();
    }

    @Override
    public int context_position() {
        return this._focus.position();
    }

    @Override
    public int last() {
        return this._focus.last();
    }

    @Override
    public Object get_variable(QName name) {
        if ("fs".equals(name.prefix())) {
            if (name.local().equals("dot")) {
                return this.context_item();
            }
            return null;
        }
        return this.get_var(name);
    }

    @Override
    public ResultSequence evaluate_function(QName name, Collection args) throws DynamicError {
        Function funct = this.function(name, args.size());
        assert (funct != null);
        return ResultSequenceUtil.newToOld(funct.evaluate(args));
    }

    @Override
    public void add_function_library(FunctionLibrary fl) {
        super.add_function_library(fl);
        fl.set_dynamic_context(this);
    }

    @Override
    public info.fingo.xactus.api.ResultSequence get_doc(URI resolved) {
        Document doc = null;
        if (this._loaded_documents.containsKey(resolved)) {
            doc = (Document)this._loaded_documents.get(resolved);
        } else {
            doc = this.retrieve_doc(resolved);
            this._loaded_documents.put(resolved, doc);
        }
        if (doc == null) {
            return null;
        }
        return ResultBuffer.wrap(new DocType(doc, this.getTypeModel(doc)));
    }

    @Override
    public URI resolve_uri(String uri) {
        try {
            URI realURI = URI.create(uri);
            if (realURI.isAbsolute()) {
                return realURI;
            }
            URI baseURI = URI.create(this.base_uri().getStringValue());
            return baseURI.resolve(uri);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private Document retrieve_doc(URI uri) {
        try {
            XercesLoader loader = new XercesLoader();
            loader.set_validating(false);
            Document doc = loader.load(new URL(uri.toString()).openStream());
            doc.setDocumentURI(uri.toString());
            return doc;
        }
        catch (DOMLoaderException e) {
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void set_variable(QName var, AnyType val) {
        super.set_variable(var, val);
    }

    @Override
    public void set_variable(QName var, ResultSequence val) {
        super.set_variable(var, val);
    }

    public void set_default_collation(String _default_collation) {
        this._default_collation_name = _default_collation;
    }

    @Override
    public String default_collation_name() {
        return this._default_collation_name;
    }

    @Override
    public Comparator get_collation(String uri) {
        if ("http://www.w3.org/2005/xpath-functions/collation/codepoint".equals(uri)) {
            return CODEPOINT_COMPARATOR;
        }
        return this._collation_provider != null ? this._collation_provider.get_collation(uri) : null;
    }

    public void set_collation_provider(CollationProvider provider) {
        this._collation_provider = provider;
    }

    @Override
    public int node_position(Node node) {
        return this._focus.position();
    }

    @Override
    public TypeModel getTypeModel(Node node) {
        return super.getTypeModel(node);
    }
}

