/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.api;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.ItemType;
import info.fingo.xactus.processor.internal.types.SimpleAtomicItemTypeImpl;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import info.fingo.xactus.processor.internal.types.builtin.SingleItemSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

public class ResultBuffer {
    private ArrayList<Item> values = new ArrayList();
    public static final ResultSequence EMPTY = new ResultSequence(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Item item(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        @Override
        public boolean empty() {
            return true;
        }

        @Override
        public ItemType itemType(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        @Override
        public ItemType sequenceType() {
            return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE, 3);
        }

        @Override
        public Object value(int index) {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        @Override
        public Object firstValue() {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        @Override
        public Item first() {
            throw new IndexOutOfBoundsException("Sequence is empty!");
        }

        @Override
        public Iterator<Item> iterator() {
            return new Iterator<Item>(){

                @Override
                public Item next() {
                    throw new IllegalStateException("This ResultSequence is empty");
                }

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }
            };
        }
    };

    public ResultSequence getSequence() {
        if (this.values.size() == 0) {
            return EMPTY;
        }
        if (this.values.size() == 1) {
            return ResultBuffer.wrap(this.values.get(0));
        }
        return new ArrayResultSequence(this.values.toArray(new Item[this.values.size()]));
    }

    public void clear() {
        this.values.clear();
    }

    public ResultBuffer add(Item at) {
        this.values.add(at);
        return this;
    }

    public ResultBuffer concat(ResultSequence rs) {
        this.values.addAll(this.collectionWrapper(rs));
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public ListIterator<Item> iterator() {
        return this.values.listIterator();
    }

    public void prepend(ResultSequence rs) {
        this.values.addAll(0, this.collectionWrapper(rs));
    }

    public Collection<Item> getCollection() {
        return this.values;
    }

    public ResultBuffer concat(Collection<Item> others) {
        this.values.addAll(others);
        return this;
    }

    public static ResultSequence wrap(Item item) {
        if (item instanceof SingleItemSequence) {
            return (SingleItemSequence)item;
        }
        return new SingleResultSequence(item);
    }

    public Item item(int index) {
        return this.values.get(index);
    }

    public void addAt(int pos, Item element) {
        this.values.add(pos, element);
    }

    private Collection<Item> collectionWrapper(final ResultSequence rs) {
        return new Collection<Item>(){

            @Override
            public boolean add(Item arg0) {
                return false;
            }

            @Override
            public boolean addAll(Collection<? extends Item> arg0) {
                return false;
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean contains(Object arg0) {
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> arg0) {
                return false;
            }

            @Override
            public boolean isEmpty() {
                return rs.empty();
            }

            @Override
            public Iterator<Item> iterator() {
                return rs.iterator();
            }

            @Override
            public boolean remove(Object arg0) {
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> arg0) {
                return false;
            }

            @Override
            public boolean retainAll(Collection<?> arg0) {
                return false;
            }

            @Override
            public int size() {
                return rs.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Item[this.size()]);
            }

            @Override
            public Object[] toArray(Object[] arg0) {
                if (arg0.length < this.size()) {
                    arg0 = new Item[this.size()];
                }
                for (int i = 0; i < this.size(); ++i) {
                    arg0[i] = rs.item(i);
                }
                return arg0;
            }
        };
    }

    public static final class ArrayResultSequence
    implements ResultSequence {
        private final Item[] results;

        public ArrayResultSequence(Item[] results) {
            this.results = results;
        }

        @Override
        public int size() {
            return this.results.length;
        }

        @Override
        public Item item(int index) {
            if (index < 0 && index >= this.results.length) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of alllowed bounds (less that " + this.results.length);
            }
            return this.results[index];
        }

        @Override
        public boolean empty() {
            return false;
        }

        @Override
        public Object firstValue() {
            return this.item(0).getNativeValue();
        }

        @Override
        public Item first() {
            return this.item(0);
        }

        @Override
        public Iterator<Item> iterator() {
            return new Iterator<Item>(){
                int nextIndex = 0;

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }

                @Override
                public final Item next() {
                    if (this.nextIndex < results.length) {
                        return results[this.nextIndex++];
                    }
                    throw new IllegalStateException("This iterator is at its end");
                }

                @Override
                public final boolean hasNext() {
                    return this.nextIndex < results.length;
                }
            };
        }

        @Override
        public ItemType itemType(int index) {
            if (index < 0 && index >= this.results.length) {
                throw new IndexOutOfBoundsException("Index " + index + " is out of alllowed bounds (less that " + this.results.length);
            }
            return this.results[index].getItemType();
        }

        @Override
        public ItemType sequenceType() {
            return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE, 3);
        }

        @Override
        public Object value(int index) {
            return this.item(index).getNativeValue();
        }
    }

    public static final class SingleResultSequence
    implements ResultSequence {
        private final Item value;

        public SingleResultSequence(Item at) {
            this.value = at;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Item item(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Length is one, you looked up number " + index);
            }
            return this.value;
        }

        @Override
        public Item first() {
            return this.item(0);
        }

        @Override
        public Object value(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Length is one, you looked up number " + index);
            }
            return this.value.getNativeValue();
        }

        @Override
        public boolean empty() {
            return false;
        }

        @Override
        public Object firstValue() {
            return this.value.getNativeValue();
        }

        @Override
        public Iterator<Item> iterator() {
            return new Iterator<Item>(){
                boolean seenIt = false;

                @Override
                public final void remove() {
                    throw new UnsupportedOperationException("ResultSequences are immutable");
                }

                @Override
                public final Item next() {
                    if (!this.seenIt) {
                        this.seenIt = true;
                        return value;
                    }
                    throw new IllegalStateException("This iterator is at its end");
                }

                @Override
                public final boolean hasNext() {
                    return !this.seenIt;
                }
            };
        }

        @Override
        public ItemType itemType(int index) {
            return this.item(index).getItemType();
        }

        @Override
        public ItemType sequenceType() {
            return this.value.getItemType();
        }
    }
}

