/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filesystem.IFileStore;
import org.ibboost.orqa.automation.events.enums.ImageWaitType;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.executors.GetElementFromImage;
import org.ibboost.orqa.automation.java.executors.ProxyExecutor;
import org.ibboost.orqa.core.execution.ExecutionContext;

public class WaitForImage
extends ProxyExecutor {
    @Override
    public Object remoteExecute(ExecutionContext context, Map<String, Object> arguments, ProxySession session, ProxyNodeReference element, UUID operationId) throws Exception {
        ImageWaitType waitType = (ImageWaitType)arguments.get("waitType");
        String target = (String)arguments.get("target");
        IFileStore image = (IFileStore)arguments.get("imageFile");
        Double threshold = (Double)arguments.get("threshold");
        Float timeout = (Float)arguments.get("timeout");
        if (timeout == null) {
            timeout = Float.valueOf(86400.0f);
        }
        long endTime = System.currentTimeMillis() + (long)(timeout.floatValue() * 1000.0f);
        do {
            try {
                GetElementFromImage.findImage(image, threshold, target, element, session, operationId, this.getRemainingTime());
                if (waitType != ImageWaitType.EXIST) continue;
                return null;
            }
            catch (GetElementFromImage.ImageNotFoundException e) {
                if (waitType != ImageWaitType.NOT_EXIST) continue;
                return null;
            }
        } while (System.currentTimeMillis() < endTime);
        throw new TimeoutException(String.format("Timed out waiting for image '%s' to %s.", image.getName(), waitType));
    }

    @Override
    public Long getTimeout() {
        return null;
    }
}

