/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.executors;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.automation.java.SupplementalLogUtils;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.OperationTimeoutException;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.execution.ExecutionContext;
import org.ibboost.orqa.core.execution.IExecutor;
import org.ibboost.orqa.core.execution.results.ExceptionMessages;

public abstract class ProxyExecutor
implements IExecutor {
    private static final Logger LOG = Logger.getLogger(ProxyExecutor.class);
    private static final int PROXY_TIMEOUT_WAIT = 300;
    private long startTime;

    public Object execute(ExecutionContext context, Map<String, Object> arguments) throws Exception {
        ProxyNodeReference element = (ProxyNodeReference)arguments.get("element");
        ProxySession session = ProxySessionManager.INSTANCE.getLastSessionUsedByThisThread();
        if (session == null) {
            throw new InvalidSessionException("No Java app has been opened or specified.");
        }
        if (!session.isAlive()) {
            throw new InvalidSessionException("The specified Java app session has been closed or is unresponsive.");
        }
        if (element != null && !element.getSessionName().equals(session.getName())) {
            throw new SessionMismatchException("The given element comes from a different Java app.");
        }
        try {
            return this.interruptableRemoteExecute(context, arguments, session, element);
        }
        catch (RemoteException e) {
            Throwable cause;
            Throwable throwable = cause = e instanceof JavaAppException ? e : e.getCause();
            if (cause instanceof JavaAppException.JavaAppWarning) {
                context.reportWarning(cause, false);
                return ((JavaAppException.JavaAppWarning)cause).getResult();
            }
            if (cause instanceof JavaAppException) {
                JavaAppException jae = (JavaAppException)cause;
                String errorMessage = ExceptionMessages.getExceptionMessage((String)jae.getMessage(), (String)jae.getLocalizedMessage(), (String)jae.getExceptionClassDisplayName(), (List)jae.getExceptionClassHeirarchy(), (Map)jae.getExceptionProperties());
                context.reportError(errorMessage);
                Object logEntry = e.getLocalizedMessage();
                if (jae.getStackTraceAsString() != null && !jae.getStackTraceAsString().isEmpty()) {
                    logEntry = (String)logEntry + "\r\nRemote Application Stack:\r\n" + jae.getStackTraceAsString();
                }
                if (cause instanceof OperationTimeoutException && ((OperationTimeoutException)cause).getThreadDump() != null && SupplementalLogUtils.isProxyThreadDumpEnabled()) {
                    File logFile = SupplementalLogUtils.getProxyLogFile("operation-timeout", "threaddump");
                    Files.write(logFile.toPath(), ((OperationTimeoutException)cause).getThreadDump().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    logEntry = (String)logEntry + "\r\n\r\nStored remote application thread dump in " + logFile.getAbsolutePath();
                } else {
                    logEntry = (String)logEntry + "\r\n\r\nTo enable remote application thread dumps, set the system property enableJavaOperationTimeoutThreadDump to true.";
                }
                LOG.error((String)logEntry);
                return null;
            }
            throw e;
        }
    }

    public Long getTimeout() {
        return 30000L;
    }

    public static Long getRemainingTime(Long timeout, long startTime) throws OperationTimeoutException {
        if (timeout == null) {
            return null;
        }
        long timeElapsed = System.currentTimeMillis() - startTime;
        Long remainingTime = timeout - timeElapsed;
        if (remainingTime <= 0L) {
            throw new OperationTimeoutException();
        }
        return remainingTime;
    }

    public Long getRemainingTime() throws OperationTimeoutException {
        return ProxyExecutor.getRemainingTime(this.getTimeout(), this.startTime);
    }

    private Object interruptableRemoteExecute(final ExecutionContext context, final Map<String, Object> arguments, final ProxySession session, final ProxyNodeReference element) throws Exception {
        final AtomicReference result = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        final UUID operationId = UUID.randomUUID();
        Thread executorThread = new Thread(){

            @Override
            public void run() {
                try {
                    result.set(ProxyExecutor.this.remoteExecute(context, arguments, session, element, operationId));
                }
                catch (Throwable t) {
                    error.set(t);
                }
            }
        };
        this.startTime = System.currentTimeMillis();
        executorThread.start();
        try {
            if (this.getTimeout() != null) {
                Long timeout = this.getTimeout() + 300L;
                executorThread.join(timeout);
                if (System.currentTimeMillis() - this.startTime >= timeout) {
                    throw new OperationTimeoutException();
                }
            } else {
                executorThread.join();
            }
            if (error.get() instanceof Exception) {
                throw (Exception)error.get();
            }
            if (error.get() instanceof Throwable) {
                throw new RuntimeException((Throwable)error.get());
            }
            return result.get();
        }
        catch (InterruptedException e) {
            executorThread.interrupt();
            try {
                session.getRemote().cancelOperation(operationId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }

    public abstract Object remoteExecute(ExecutionContext var1, Map<String, Object> var2, ProxySession var3, ProxyNodeReference var4, UUID var5) throws Exception;

    private class InvalidSessionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidSessionException(String message) {
            super(message);
        }
    }

    private class SessionMismatchException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SessionMismatchException(String message) {
            super(message);
        }
    }
}

