/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.dom;

import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.ImageData;
import org.ibboost.orqa.automation.AutomationElement;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.dom.JavaDocument;
import org.ibboost.orqa.automation.java.dom.JavaText;
import org.ibboost.orqa.xpath.XPathNode;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.ibboost.orqa.xpath.XPathPreferences;
import org.w3c.dom.Node;

public class JavaElement
extends AutomationElement
implements IAdaptable {
    private final ProxyNodeReference nodeReference;
    private final ProxySession session;

    public JavaElement(ProxyNodeReference nodeReference, ProxySession session, XPathParentNode parent) {
        super(parent);
        this.nodeReference = nodeReference;
        this.session = session;
    }

    public ProxyNodeReference getNodeReference() {
        return this.nodeReference;
    }

    protected String initTagName() {
        return this.nodeReference.getNodeName();
    }

    protected String[] initAttributeNames() {
        try {
            return this.session.getRemote().getNodeAttributeNames(this.nodeReference);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAttribute(String name) {
        try {
            return this.session.getRemote().getNodeAttribute(this.nodeReference, name);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<XPathNode> initChildren() {
        try {
            ArrayList<XPathNode> children = new ArrayList<XPathNode>();
            IAutomationProxy remote = this.session.getRemote();
            List childReferences = remote.getNodeChildren(this.nodeReference);
            for (ProxyNodeReference childReference : childReferences) {
                children.add((XPathNode)new JavaElement(childReference, this.session, (XPathParentNode)this));
            }
            if (remote.getNodeTextValue(this.nodeReference) != null) {
                children.add((XPathNode)new JavaText(this.session, this));
            }
            return children;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSameNode(Node other) {
        if (!(other instanceof JavaElement)) {
            return false;
        }
        JavaElement otherElement = (JavaElement)((Object)other);
        if (otherElement.session != this.session) {
            return false;
        }
        try {
            return this.session.getRemote().isSameNode(this.nodeReference, otherElement.getNodeReference());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getXPath(Boolean optimize) throws Exception {
        if (optimize == null) {
            optimize = XPathPreferences.getStore().getBoolean("xpath.optimize");
        }
        return this.session.getRemote().getNodeXPath(this.nodeReference, IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES, optimize.booleanValue());
    }

    public Rectangle getWindowRelativeBounds() throws Exception {
        return this.session.getRemote().getNodeWindowRelativeBounds(this.nodeReference, null);
    }

    public void dispose() {
        try {
            this.session.getRemote().freeNodeReference(this.nodeReference);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Node[] findSubElementPathByPosition(int xOffset, int yOffset) {
        ProxyNodeReference subNode;
        IAutomationProxy remote;
        block3: {
            try {
                remote = this.session.getRemote();
                subNode = remote.getSubNodeFromLocation(this.nodeReference, xOffset, yOffset, null, null);
                if (subNode != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        ProxyNodeReference[] nodeRefPath = remote.getNodePath(subNode);
        remote.freeNodeReference(subNode);
        return JavaDocument.nodeRefPathToNodePath(this.session, nodeRefPath);
    }

    public ImageData captureImage() {
        try {
            byte[] image = this.session.getRemote().captureNodeImage(this.nodeReference, null, null);
            if (image != null) {
                return new ImageData((InputStream)new ByteArrayInputStream(image));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ImageData.class) {
            return adapter.cast(this.captureImage());
        }
        return null;
    }
}

