/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.dom;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.ibboost.orqa.automation.AutomationDocument;
import org.ibboost.orqa.automation.AutomationSession;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.dom.JavaElement;
import org.ibboost.orqa.xpath.XPathNode;
import org.ibboost.orqa.xpath.XPathParentNode;
import org.w3c.dom.Node;

public class JavaDocument
extends AutomationDocument<ProxySession> {
    private final ProxyNodeReference rootNodeReference;

    public JavaDocument(ProxySession session) {
        super((AutomationSession)session);
        this.rootNodeReference = new ProxyNodeReference(session.getName(), null, "#document");
    }

    protected List<XPathNode> initChildren() {
        ArrayList<XPathNode> result = new ArrayList<XPathNode>();
        try {
            List childNodeReferences = ((ProxySession)this.session).getRemote().getNodeChildren(this.rootNodeReference);
            for (ProxyNodeReference childNodeReference : childNodeReferences) {
                result.add((XPathNode)new JavaElement(childNodeReference, (ProxySession)this.session, (XPathParentNode)this));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    public ProxyNodeReference getNodeReference() {
        return this.rootNodeReference;
    }

    public boolean isSameNode(Node other) {
        return other instanceof JavaDocument && ((JavaDocument)((Object)other)).session == this.session;
    }

    public List<Node[]> getElementPaths(String xpath) throws Exception {
        ArrayList<Node[]> result = new ArrayList<Node[]>();
        IAutomationProxy proxy = ((ProxySession)this.session).getRemote();
        List nodeRefs = proxy.getNodesFromXPath(null, xpath, true, null, null);
        for (ProxyNodeReference nodeRef : nodeRefs) {
            ProxyNodeReference[] nodeRefPath = proxy.getNodePath(nodeRef);
            result.add(JavaDocument.nodeRefPathToNodePath((ProxySession)this.session, nodeRefPath));
            proxy.freeNodeReference(nodeRef);
        }
        return result;
    }

    public static Node[] nodeRefPathToNodePath(ProxySession session, ProxyNodeReference[] nodeRefPath) throws Exception {
        if (nodeRefPath == null || nodeRefPath.length == 0) {
            return null;
        }
        XPathParentNode[] path = new XPathParentNode[nodeRefPath.length];
        path[0] = new JavaDocument(session){

            @Override
            protected List<XPathNode> initChildren() {
                return new ArrayList<XPathNode>();
            }
        };
        int i = 1;
        while (i < nodeRefPath.length) {
            XPathParentNode parentNode = path[i - 1];
            JavaElement node = new JavaElement(nodeRefPath[i], session, parentNode){

                @Override
                protected List<XPathNode> initChildren() {
                    return new ArrayList<XPathNode>();
                }
            };
            parentNode.addChild((XPathNode)node);
            path[i] = node;
            ++i;
        }
        return path;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == String.class) {
            try {
                return adapter.cast(((ProxySession)this.session).getRemote().getNodeXml(this.rootNodeReference));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return (T)super.getAdapter(adapter);
    }
}

