/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.awt.Point;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.ibboost.orqa.automation.java.JavaAutomationPreferences;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.INodeCaptureReceiver;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.ui.editors.IEditorValuePicker;
import org.ibboost.orqa.core.ui.editors.PropertyEditor;
import org.ibboost.orqa.xpath.XPathPreferences;

public class XPathPicker
implements IEditorValuePicker {
    private static final Logger LOG = Logger.getLogger(XPathPicker.class);
    private static List<XPathPickerReceiver> nodeCaptureReceivers;
    private static final RMILoopbackSocketFactory SOCKET_FACTORY;

    static {
        SOCKET_FACTORY = new RMILoopbackSocketFactory();
    }

    public synchronized void open(final Shell shell, PropertyEditor<?> pickerEditor, Map<String, PropertyEditor<?>> propertyPageEditorSet) {
        ProxySession session2;
        this.cancel();
        boolean optimizeXPath = XPathPreferences.getStore().getBoolean("xpath.optimize");
        nodeCaptureReceivers = new ArrayList<XPathPickerReceiver>();
        for (ProxySession session2 : ProxySessionManager.INSTANCE.getSessions(true)) {
            try {
                IAutomationProxy proxy = session2.getRemote();
                PropertyEditor<?> xClickOffsetEditor = this.getXClickOffsetEditor(propertyPageEditorSet);
                PropertyEditor<?> yClickOffsetEditor = this.getYClickOffsetEditor(propertyPageEditorSet);
                XPathPickerReceiver nodeCaptureReceiver = new XPathPickerReceiver(pickerEditor, xClickOffsetEditor, yClickOffsetEditor, proxy);
                proxy.registerNodeCaptureReceiver((INodeCaptureReceiver)nodeCaptureReceiver, true, optimizeXPath, JavaAutomationPreferences.getStore().getBoolean("java.glasspane.suppress"));
                nodeCaptureReceivers.add(nodeCaptureReceiver);
            }
            catch (RemoteException e) {
                LOG.error(e.getClass().getSimpleName(), (Throwable)e);
            }
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                XPathPicker.this.cancel();
                shell.removeDisposeListener((DisposeListener)this);
            }
        });
        session2 = ProxySessionManager.INSTANCE.getLastSession();
        Iterator<ProxySession> sessionIterator = ProxySessionManager.INSTANCE.getSessions(true).iterator();
        while (sessionIterator.hasNext() && (session2 == null || !session2.isAlive())) {
            session2 = sessionIterator.next();
        }
        final ProxySession targetSession = session2;
        if (targetSession != null && targetSession.isAlive()) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        targetSession.bringToFront();
                    }
                    catch (Exception e) {
                        LOG.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }.start();
        }
    }

    protected PropertyEditor<?> getXClickOffsetEditor(Map<String, PropertyEditor<?>> propertyPageEditorSet) {
        return null;
    }

    protected PropertyEditor<?> getYClickOffsetEditor(Map<String, PropertyEditor<?>> propertyPageEditorSet) {
        return null;
    }

    private void cancel() {
        if (nodeCaptureReceivers != null) {
            for (XPathPickerReceiver receiver : nodeCaptureReceivers) {
                try {
                    receiver.proxy.unregisterNodeCaptureReceiver((INodeCaptureReceiver)receiver);
                }
                catch (RemoteException e) {
                    LOG.error(e.getClass().getSimpleName(), (Throwable)e);
                }
            }
            nodeCaptureReceivers = null;
        }
    }

    public static class ClickXPathPicker
    extends XPathPicker {
        @Override
        protected PropertyEditor<?> getXClickOffsetEditor(Map<String, PropertyEditor<?>> propertyPageEditorSet) {
            return propertyPageEditorSet.get("x");
        }

        @Override
        protected PropertyEditor<?> getYClickOffsetEditor(Map<String, PropertyEditor<?>> propertyPageEditorSet) {
            return propertyPageEditorSet.get("y");
        }
    }

    private static class XPathPickerReceiver
    extends UnicastRemoteObject
    implements INodeCaptureReceiver {
        private static final long serialVersionUID = 1L;
        private final UUID id = UUID.randomUUID();
        private final PropertyEditor<?> xPathEditor;
        private final PropertyEditor<?> xOffsetEditor;
        private final PropertyEditor<?> yOffsetEditor;
        private final IAutomationProxy proxy;

        public XPathPickerReceiver(PropertyEditor<?> xPathEditor, PropertyEditor<?> xOffsetEditor, PropertyEditor<?> yOffsetEditor, IAutomationProxy proxy) throws RemoteException {
            super(0, (RMIClientSocketFactory)SOCKET_FACTORY, (RMIServerSocketFactory)SOCKET_FACTORY);
            this.xPathEditor = xPathEditor;
            this.xOffsetEditor = xOffsetEditor;
            this.yOffsetEditor = yOffsetEditor;
            this.proxy = proxy;
        }

        public void nodeCaptured(ProxyNodeReference node, final String nodeXPath, final Point clickOffset) throws RemoteException {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (xPathEditor != null) {
                                xPathEditor.setValue(nodeXPath);
                            }
                            if (xOffsetEditor != null) {
                                xOffsetEditor.setValue(Integer.toString(clickOffset.x));
                            }
                            if (yOffsetEditor != null) {
                                yOffsetEditor.setValue(Integer.toString(clickOffset.y));
                            }
                        }
                        catch (SWTException sWTException) {
                            // empty catch block
                        }
                    }
                });
                this.proxy.freeNodeReference(node);
            }
            catch (Exception e) {
                LOG.error(e.getClass().getSimpleName(), (Throwable)e);
            }
        }

        public UUID getId() throws RemoteException {
            return this.id;
        }
    }
}

