/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.ibboost.orqa.automation.AutomationSessionManager;
import org.ibboost.orqa.automation.java.ProxyRunner;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.session.ISessionListener;
import org.ibboost.orqa.session.Session;
import org.ibboost.orqa.session.SessionManager;

public class ProxySessionManager
extends SessionManager<ProxySession> {
    private static Map<String, ProxySession> allSessions = new ConcurrentHashMap<String, ProxySession>();
    private static InheritableThreadLocal<String> lastSession = new InheritableThreadLocal();
    private static List<ISessionListener> sessionListeners = new ArrayList<ISessionListener>();
    private static String lastSessionGlobal = null;
    public static final ProxySessionManager INSTANCE = new ProxySessionManager();

    private ProxySessionManager() {
        AutomationSessionManager.registerChildSessionManager((SessionManager)this);
    }

    public ProxySession attachSession(String sessionName, int pid) throws Exception {
        return this.attachSession(sessionName, null, pid);
    }

    public ProxySession attachSession(String sessionName, String windowName) throws Exception {
        return this.attachSession(sessionName, windowName, null);
    }

    private ProxySession attachSession(String sessionName, String windowName, Integer pid) throws Exception {
        String givenSessionName = sessionName;
        sessionName = sessionName != null ? sessionName : UUID.randomUUID().toString();
        ProxySession namedSession = this.getSession(givenSessionName);
        ArrayList<ProxySession> sessions = new ArrayList<ProxySession>(this.getSessions(true));
        if (namedSession != null && namedSession.isAlive()) {
            sessions.remove((Object)namedSession);
            sessions.add(0, namedSession);
        }
        ProxySession targetSession = null;
        ArrayList<Integer> sessionIds = new ArrayList<Integer>();
        for (ProxySession session : sessions) {
            try {
                Integer sessionPid = session.getProcessId();
                if (sessionPid != null) {
                    sessionIds.add(sessionPid);
                }
                if (pid != null) {
                    if (sessionPid == null || !sessionPid.equals(pid)) continue;
                    targetSession = session;
                    break;
                }
                if (!session.getRemote().hasWindow(windowName)) continue;
                targetSession = session;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (targetSession != null) {
            if (givenSessionName != null && !targetSession.getName().equals(givenSessionName)) {
                targetSession = new ProxySession(givenSessionName, sessionName, targetSession.getRmiRegistryController(), targetSession.getRemote());
            }
        } else {
            targetSession = pid != null ? ProxyRunner.attachRmiProcess(givenSessionName, sessionName, pid) : ProxyRunner.attachRmiProcess(givenSessionName, sessionName, windowName, sessionIds);
            ProxySessionManager.monitorSessionShutdown(targetSession);
        }
        ProxySessionManager.addSession(targetSession);
        return targetSession;
    }

    public ProxySession startSession(String sessionName, String workingDirectory, String jvmPath, String command, boolean autoClose, boolean allowSystemClassLoaderOverride) throws Exception {
        String givenSessionName = sessionName;
        sessionName = sessionName != null ? sessionName : UUID.randomUUID().toString();
        ProxySession session = ProxyRunner.runRmiProcess(command, jvmPath, workingDirectory, givenSessionName, sessionName, autoClose, allowSystemClassLoaderOverride);
        ProxySessionManager.addSession(session);
        ProxySessionManager.monitorSessionShutdown(session);
        return session;
    }

    private static void addSession(ProxySession session) {
        allSessions.put(session.getName(), session);
        for (ISessionListener listener : sessionListeners) {
            listener.newSession((Session)session);
        }
    }

    private static void monitorSessionShutdown(final ProxySession session) {
        new Thread(){

            @Override
            public void run() {
                try {
                    session.getRemote().blockUntilAppCloses();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    session.close(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ProxySessionManager.removeExpiredSession(session);
            }
        }.start();
    }

    private static void removeExpiredSession(ProxySession expiredSession) {
        for (ProxySession session : new ArrayList<ProxySession>(allSessions.values())) {
            try {
                if (session != expiredSession && session.getRemote() != expiredSession.getRemote()) continue;
                allSessions.remove(session.getName());
                for (ISessionListener listener : sessionListeners) {
                    listener.sessionClosed((Session)session);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ProxySession getSession(String sessionName) {
        if (sessionName == null) {
            return null;
        }
        return allSessions.get(sessionName);
    }

    public void setLastSession(ProxySession session) {
        String sessionName = session != null ? session.getName() : null;
        lastSession.set(sessionName);
        lastSessionGlobal = sessionName;
    }

    public ProxySession getLastSessionUsedByThisThread() {
        return this.getSession((String)lastSession.get());
    }

    public ProxySession getLastSession() {
        return this.getSession(lastSessionGlobal);
    }

    public void prepareForOrqaShutdown() {
        for (ProxySession session : this.getSessions(true)) {
            session.prepareForOrqaShutdown();
        }
    }

    public Collection<ProxySession> getSessions(boolean purgeDeadSessions) {
        ArrayList<ProxySession> result = new ArrayList<ProxySession>();
        for (ProxySession session : new ArrayList<ProxySession>(allSessions.values())) {
            if (purgeDeadSessions && !session.isAlive()) {
                ProxySessionManager.removeExpiredSession(session);
                continue;
            }
            result.add(session);
        }
        return result;
    }

    public void closeSession(Session session) {
        ProxySession proxySession = (ProxySession)session;
        if (proxySession != null) {
            proxySession.close();
            ProxySessionManager.removeExpiredSession(proxySession);
        }
    }

    public void addSesssionListener(ISessionListener sessionListener) {
        sessionListeners.add(sessionListener);
    }

    public void removeSesssionListener(ISessionListener sessionListener) {
        sessionListeners.remove(sessionListener);
    }

    public List<Class<? extends ProxySession>> getSessionTypes() {
        return Arrays.asList(ProxySession.class);
    }
}

