/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.awt.Point;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.ibboost.orqa.automation.AutomationSession;
import org.ibboost.orqa.automation.IElementReceiver;
import org.ibboost.orqa.automation.IEventReceiver;
import org.ibboost.orqa.automation.java.JavaAutomationActivator;
import org.ibboost.orqa.automation.java.JavaAutomationPreferences;
import org.ibboost.orqa.automation.java.ProxyCallBack;
import org.ibboost.orqa.automation.java.ProxyEventReceiver;
import org.ibboost.orqa.automation.java.ProxyRunner;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.INodeCaptureReceiver;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.JavaProcessOutputConsumer;
import org.ibboost.orqa.automation.java.common.ProxyNodeReference;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;
import org.ibboost.orqa.automation.java.common.RmiRegistryController;
import org.ibboost.orqa.automation.java.dom.JavaDocument;
import org.ibboost.orqa.xpath.XPathExpression;
import org.ibboost.orqa.xpath.XPathPreferences;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ProxySession
extends AutomationSession {
    private static final ImageDescriptor JAVA_ICON = AbstractUIPlugin.imageDescriptorFromPlugin((String)JavaAutomationActivator.PLUGIN_ID, (String)"images/java.png");
    public static final String JAVA_SESSION_TYPE_DISPLAY_NAME = "Java App";
    private static final int GRACEFUL_SHUTDOWN_TIMEOUT = 3000;
    private final String givenSessionName;
    private final String sessionName;
    private final String workingDirectory;
    private final String givenJvmPath;
    private final String jvmPath;
    private final String command;
    private final RmiRegistryController rmiRegistryController;
    private final Process process;
    private final JavaProcessOutputConsumer outputConsumer;
    private Integer pid;
    private IAutomationProxy remote;
    private ProxyCallBack callback;
    private IRemoteEventReceiver eventReceiver;
    private INodeCaptureReceiver elementReceiver;
    private boolean sessionExpired = false;
    private boolean closed = false;

    protected ProxySession(String givenSessionName, String sessionName, RmiRegistryController rmiRegistryController, IAutomationProxy remote) {
        this(givenSessionName, sessionName, null, null, null, null, rmiRegistryController, remote, null, null, null);
    }

    protected ProxySession(String givenSessionName, String sessionName, String workingDirectory, String jvmPath, String givenJvmPath, String command, RmiRegistryController rmiRegistryController, IAutomationProxy remote, ProxyCallBack callback, Process process, JavaProcessOutputConsumer outputConsumer) {
        this.givenSessionName = givenSessionName;
        this.sessionName = sessionName;
        this.workingDirectory = workingDirectory;
        this.jvmPath = jvmPath;
        this.givenJvmPath = givenJvmPath;
        this.command = command;
        this.rmiRegistryController = rmiRegistryController;
        this.remote = remote;
        this.callback = callback;
        this.process = process;
        this.outputConsumer = outputConsumer;
        try {
            this.pid = remote.getPid();
            Integer preferredXPathVersion = XPathExpression.getPreferredXPathVersion();
            if (preferredXPathVersion != null) {
                remote.setPreferredXPathVersion(preferredXPathVersion);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IAutomationProxy getRemote() {
        return this.remote;
    }

    public static String getSessionDisplayName(String givenSessionName) {
        if (givenSessionName != null && !givenSessionName.isEmpty()) {
            return givenSessionName;
        }
        return "Unnamed Java Session";
    }

    public String getDisplayName() {
        if (this.givenSessionName != null && !this.givenSessionName.isEmpty()) {
            return this.givenSessionName;
        }
        Object sessionName = ProxySession.getSessionDisplayName(this.givenSessionName);
        if (this.getCommand() != null) {
            sessionName = (String)sessionName + " (" + this.getCommand() + ")";
        }
        if (this.getProcessId() != null) {
            sessionName = (String)sessionName + " (PID:" + String.valueOf(this.getProcessId()) + ")";
        }
        return sessionName;
    }

    public String getGivenName() {
        return this.givenSessionName;
    }

    public String getName() {
        return this.sessionName;
    }

    public String getSessionTypeDisplayName() {
        return JAVA_SESSION_TYPE_DISPLAY_NAME;
    }

    public String getOpIdPrefix() {
        return "java";
    }

    public ImageDescriptor getIcon() {
        return JAVA_ICON;
    }

    public String getWorkingDirectory() throws IOException {
        if (this.command != null) {
            if (this.workingDirectory != null) {
                return this.workingDirectory;
            }
            return System.getProperty("user.dir");
        }
        return this.remote.getWorkingDirectory();
    }

    public String getCommandLine() throws IOException {
        if (this.command != null) {
            return this.command;
        }
        return ProxyRunner.getCommandLineArgs(Arrays.asList(this.pid)).get(this.pid);
    }

    public String getJvmPath() {
        return this.jvmPath;
    }

    public String getGivenJvmPath() {
        return this.givenJvmPath;
    }

    public String getCommand() {
        return this.command;
    }

    public Integer getProcessId() {
        return this.pid;
    }

    public void bringToFront() throws Exception {
        ProxySession.allowSetForegroundWindows();
        this.remote.bringWindowsToFront();
    }

    public List<String> getWindowNames() throws IOException {
        return this.remote.getWindowNames();
    }

    private static void allowSetForegroundWindows() {
        try {
            Bundle swt = Platform.getBundle((String)"org.eclipse.swt");
            Class OS = swt.loadClass("org.eclipse.swt.internal.win32.OS");
            Method allowSetForegroundWindow = OS.getMethod("AllowSetForegroundWindow", Integer.TYPE);
            allowSetForegroundWindow.invoke((Object)OS, -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RmiRegistryController getRmiRegistryController() {
        return this.rmiRegistryController;
    }

    public boolean isAlive() {
        if (this.sessionExpired) {
            return false;
        }
        try {
            return this.remote.isSessionAlive();
        }
        catch (Exception e) {
            this.sessionExpired = true;
            return false;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean sendShutdownSignal) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (sendShutdownSignal) {
            try {
                this.remote.terminate(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread gracefulShutdownMonitor = new Thread(){

            @Override
            public void run() {
                try {
                    if (ProxySession.this.outputConsumer != null) {
                        ProxySession.this.outputConsumer.awaitApplicationTermination();
                    } else {
                        ProxySession.this.remote.blockUntilAppCloses();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        gracefulShutdownMonitor.start();
        try {
            gracefulShutdownMonitor.join(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (this.callback != null) {
                this.callback.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.outputConsumer != null) {
                this.outputConsumer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rmiRegistryController.stopRMIRegistry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remote = null;
        this.callback = null;
    }

    public void prepareForOrqaShutdown() {
        try {
            if (this.callback != null) {
                this.callback.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Document getSessionDocument() {
        return new JavaDocument(this);
    }

    public void startEventCapture(IEventReceiver receiver, boolean captureXmlSnapshots, boolean isNewSession) throws Exception {
        this.stopEventCapture();
        this.eventReceiver = new ProxyEventReceiver(this.remote, receiver);
        boolean optimizeXPaths = XPathPreferences.getStore().getBoolean("xpath.optimize");
        this.remote.registerEventRecever(this.eventReceiver, optimizeXPaths, captureXmlSnapshots, JavaAutomationPreferences.getStore().getBoolean("java.glasspane.suppress"));
    }

    public void startElementCapture(IElementReceiver receiver) throws Exception {
        this.stopElementCapture();
        this.elementReceiver = new RemoteElementReceiver(receiver, this);
        this.remote.registerNodeCaptureReceiver(this.elementReceiver, false, false, JavaAutomationPreferences.getStore().getBoolean("java.glasspane.suppress"));
    }

    public void stopElementCapture() {
        if (this.elementReceiver != null) {
            try {
                this.remote.unregisterNodeCaptureReceiver(this.elementReceiver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.elementReceiver = null;
    }

    public void stopEventCapture() {
        if (this.eventReceiver != null) {
            try {
                this.remote.unregisterEventReceiver(this.eventReceiver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.eventReceiver = null;
    }

    private static class RemoteElementReceiver
    extends UnicastRemoteObject
    implements INodeCaptureReceiver {
        private static final long serialVersionUID = 1L;
        private static final RMILoopbackSocketFactory SOCKET_FACTORY = new RMILoopbackSocketFactory();
        private final UUID ID = UUID.randomUUID();
        private final IElementReceiver localReceiver;
        private final ProxySession session;

        protected RemoteElementReceiver(IElementReceiver localReceiver, ProxySession session) throws RemoteException {
            super(0, (RMIClientSocketFactory)SOCKET_FACTORY, (RMIServerSocketFactory)SOCKET_FACTORY);
            this.localReceiver = localReceiver;
            this.session = session;
        }

        public void nodeCaptured(ProxyNodeReference node, String nodeXPath, Point clickOffset) throws RemoteException {
            try {
                IAutomationProxy remote = this.session.getRemote();
                ProxyNodeReference[] nodeRefPath = remote.getNodePath(node);
                Node[] nodePath = JavaDocument.nodeRefPathToNodePath(this.session, nodeRefPath);
                if (nodePath != null) {
                    this.localReceiver.newElement(nodePath);
                }
                remote.freeNodeReference(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public UUID getId() throws RemoteException {
            return this.ID;
        }
    }
}

