/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.rmi.Remote;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.ibboost.orqa.automation.PolicyManager;
import org.ibboost.orqa.automation.java.AttachableJavaWindow;
import org.ibboost.orqa.automation.java.JavaAutomationPreferences;
import org.ibboost.orqa.automation.java.LogCallBack;
import org.ibboost.orqa.automation.java.ProxyCallBack;
import org.ibboost.orqa.automation.java.ProxySession;
import org.ibboost.orqa.automation.java.ProxySessionManager;
import org.ibboost.orqa.automation.java.SupplementalLogUtils;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.JavaProcessOutputConsumer;
import org.ibboost.orqa.automation.java.common.JvmTools;
import org.ibboost.orqa.automation.java.common.ProxySystemClassLoader;
import org.ibboost.orqa.automation.java.common.RmiRegistryController;
import org.ibboost.orqa.core.ArgParser;
import org.ibboost.orqa.core.FileUtils;
import org.ibboost.orqa.core.JarUtils;
import org.ibboost.orqa.core.Logger;
import org.ibboost.orqa.core.OSUtils;
import org.ibboost.orqa.core.ProcessUtils;
import org.ibboost.orqa.core.StringUtils;
import org.ibboost.orqa.core.ZipUtils;

public class ProxyRunner {
    private static final Logger LOG = Logger.getLogger(ProxyRunner.class);
    private static final int PROXY_REGISTRATION_TIMEOUT = 10000;
    private static final int DEBUG_PORT = 8001;
    private static final int ATTACHER_DEBUG_PORT = 8003;
    private static final int MIN_JAVA_JIGSAW_VERSION = 9;
    private static final List<String> JAVA_EXECUTABLES = Arrays.asList("java", "java.exe", "javaw", "javaw.exe", "javaws", "javaws.exe");
    private static final List<String> JAVAWS_EXECUTABLES = Arrays.asList("javaw", "javaw.exe");
    private static final String SYSTEM_CLASSLOADER_PROPERTY = "java.system.class.loader";
    private static final String CLASSPATH_SEPARATOR = OSUtils.isWindows() ? ";" : ":";
    private static final List<String> JVM_2_PART_ARGS = Arrays.asList("-classpath", "-class-path", "-cp", "-jar", "-m", "--module", "--module-path", "-p", "--upgrade-module-path", "--add-modules", "-d", "--describe-module", "--add-reads", "--add-exports", "--add-opens", "--limit-modules", "--patch-module", "--source");
    private static final List<String> JVM_CLASS_PATH_ARGS = Arrays.asList("-classpath", "-class-path", "-cp");

    public static List<AttachableJavaWindow> getAttachableWindows(boolean getCommandLineArgs) throws Exception {
        ArrayList<AttachableJavaWindow> windows = new ArrayList<AttachableJavaWindow>();
        HashMap<Integer, String> jdks = JavaAutomationPreferences.getJdks();
        for (Map.Entry<Integer, String> entry : jdks.entrySet()) {
            String jdk = entry.getValue();
            Integer architecture = entry.getKey();
            List<String> args = Arrays.asList("--appDetails");
            Map.Entry<Integer, String> result = ProxyRunner.runAttacherJar(jdk, architecture, args);
            String stdOut = result.getValue().trim().replaceAll("\r", "");
            Map commandLineArgs = Collections.emptyMap();
            if (getCommandLineArgs) {
                ArrayList<Integer> pids = new ArrayList<Integer>();
                String[] stringArray = stdOut.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.startsWith("pid:")) {
                        pids.add(Integer.valueOf(line.substring("pid:".length())));
                    }
                    ++n2;
                }
                commandLineArgs = ProxyRunner.getCommandLineArgs(pids);
            }
            Integer processId = null;
            String workingDirectory = null;
            String jvmPath = null;
            String[] stringArray = stdOut.split("\n");
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String line = stringArray[n3];
                int seperatorIndex = line.indexOf(":");
                if (seperatorIndex >= 0) {
                    String key = line.substring(0, seperatorIndex);
                    String value = line.substring(seperatorIndex + 1);
                    if (key.equals("pid")) {
                        processId = Integer.valueOf(value);
                        workingDirectory = null;
                        jvmPath = null;
                    }
                    if (key.equals("jvmPath")) {
                        jvmPath = value;
                    } else if (key.equals("workingDirectory")) {
                        workingDirectory = value;
                    } else if (key.equals("window")) {
                        String windowName = value;
                        String processArgs = (String)commandLineArgs.get(processId);
                        if (!(getCommandLineArgs && processArgs == null || windowName.trim().isEmpty())) {
                            windows.add(new AttachableJavaWindow(windowName, processId, jvmPath, workingDirectory, processArgs));
                        }
                    }
                }
                ++n3;
            }
        }
        return windows;
    }

    private static boolean isDebuggerListening(int port) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ServerSocket debugSocket = new ServerSocket(port);
                if (debugSocket != null) {
                    debugSocket.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BindException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean awaitJavaAppRegistration(final ProxyCallBack proxyCallBack, final JavaProcessOutputConsumer outputConsumer, boolean javaWsApp) throws InterruptedException {
        final AtomicBoolean proxyRegistationSucceeded = new AtomicBoolean();
        final Thread registrationMonitor = new Thread(){

            @Override
            public void run() {
                proxyRegistationSucceeded.set(proxyCallBack.waitForRegistration(10000000));
            }
        };
        registrationMonitor.start();
        if (!javaWsApp) {
            Thread terminationMonitor = new Thread(){

                @Override
                public void run() {
                    try {
                        outputConsumer.awaitApplicationTermination();
                        registrationMonitor.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            terminationMonitor.start();
            registrationMonitor.join();
            terminationMonitor.interrupt();
        } else {
            registrationMonitor.join();
        }
        return proxyRegistationSucceeded.get();
    }

    public static ProxySession runRmiProcess(String command, String givenJvmPath, String workingDirectory, String givenSessionName, String sessionName, boolean autoClose, boolean allowSystemClassLoaderOverride) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ProxySessionManager.class.getClassLoader());
            RmiRegistryController registryController = new RmiRegistryController();
            Integer port = registryController.getRegistryPort();
            String jvmPath = givenJvmPath != null ? givenJvmPath : System.getProperties().getProperty("java.home");
            JavaAppLaunchParameters launchParams = ProxyRunner.getJavaAppLaunchParmeters(workingDirectory, command, jvmPath, port, sessionName, autoClose, allowSystemClassLoaderOverride);
            ProxyCallBack proxyCallBack = new ProxyCallBack();
            RmiRegistryController.bind((String)"ORQA_RMI_HOST_CLASS", (int)port, (Remote)proxyCallBack);
            RmiRegistryController.bind((String)"ORQA_RMI_LOG_CALLBACK", (int)port, (Remote)new LogCallBack());
            LinkedList<String> processCommand = new LinkedList<String>();
            processCommand.add(launchParams.executable.getAbsolutePath());
            processCommand.addAll(launchParams.jvmArgs);
            processCommand.addAll(launchParams.appArgs);
            ProcessBuilder builder = new ProcessBuilder(processCommand);
            builder.directory(launchParams.workingDirectory);
            builder.environment().putAll(launchParams.environmentVariables);
            builder.environment().put("JAVA_TOOL_OPTIONS", ArgParser.argsToString(launchParams.javaToolOptions));
            builder.environment().put("CLASSPATH", launchParams.envClassPath);
            System.out.println("Starting Java App:");
            System.out.println("\tCommand:");
            for (String string : processCommand) {
                System.out.println("\t\t" + string);
            }
            System.out.println("\tWorking Dir:\t" + String.valueOf(launchParams.workingDirectory));
            System.out.println("\tEnv:");
            for (Map.Entry entry : builder.environment().entrySet()) {
                System.out.println("\t\t" + (String)entry.getKey() + ":\t" + (String)entry.getValue());
            }
            boolean bl = JAVAWS_EXECUTABLES.contains(launchParams.executable.getName().toLowerCase());
            String processName = "Java Automation App" + (String)(givenSessionName != null && !givenSessionName.isEmpty() ? " - " + givenSessionName : "");
            Process process = ProcessUtils.startProcess((ProcessBuilder)builder, (String)processName);
            JavaProcessOutputConsumer outputConsumer = new JavaProcessOutputConsumer(process, false, true);
            if (!ProxyRunner.awaitJavaAppRegistration(proxyCallBack, outputConsumer, bl)) {
                try {
                    proxyCallBack.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    registryController.stopRMIRegistry();
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                outputConsumer.close();
                throw new RuntimeException(outputConsumer.getErrorMessage() != null ? outputConsumer.getErrorMessage() : "Could not connect to Java App");
            }
            IAutomationProxy automationProxy = (IAutomationProxy)RmiRegistryController.lookup((String)"ORQA_RMI_CLASS", (int)port);
            ProxySession proxySession = new ProxySession(givenSessionName, sessionName, workingDirectory, jvmPath, givenJvmPath, command, registryController, automationProxy, proxyCallBack, process, outputConsumer);
            return proxySession;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static JavaAppLaunchParameters getJavaAppLaunchParmeters(String workingDirectory, String command, String jvmPath, Integer rmiPort, String sessionName, boolean autoClose, boolean allowSystemClassLoaderOverride) throws Exception {
        boolean debugMode;
        JavaAppLaunchParameters launchParams = new JavaAppLaunchParameters();
        File proxyJar = new File(JarUtils.findPluginJar((String)"orqa-automation-java-proxy"));
        LinkedList<String> givenArgs = new LinkedList<String>(ArgParser.parseArgs((String)command));
        String executableArg = (String)givenArgs.remove(0);
        launchParams.javaToolOptions.addAll(ArgParser.parseArgs((String)StringUtils.blankIfEmpty((String)System.getenv("JAVA_TOOL_OPTIONS"))));
        launchParams.envClassPath = StringUtils.blankIfEmpty((String)System.getenv("CLASSPATH"));
        File file = launchParams.workingDirectory = workingDirectory != null && !workingDirectory.trim().isEmpty() ? new File(workingDirectory) : FileUtils.getOrqaWorkingDirectory();
        if (!launchParams.workingDirectory.isDirectory()) {
            throw new Exception(String.format("Could not find working directory at %s", launchParams.workingDirectory));
        }
        launchParams.executable = ProxyRunner.evaluateExecutable(executableArg, jvmPath, launchParams.workingDirectory);
        Map.Entry<List<String>, List<String>> splitArgs = ProxyRunner.splitJvmAndAppArgs(launchParams.executable, givenArgs);
        launchParams.jvmArgs = splitArgs.getKey();
        launchParams.appArgs = splitArgs.getValue();
        if (JAVAWS_EXECUTABLES.contains(launchParams.executable.getName().toLowerCase())) {
            launchParams.jvmArgs.add(0, "-J-Djava.security.policy=" + PolicyManager.getPolicyFile((String)"javaws.policy").getCanonicalPath());
            launchParams.environmentVariables.put("ORQA_WEBSTART_APP", "true");
        }
        launchParams.environmentVariables.put("ORQA_RMI_PORT", rmiPort.toString());
        launchParams.environmentVariables.put("ORQA_RMI_SESSION_NAME", sessionName);
        launchParams.javaToolOptions.add("-javaagent:" + proxyJar.getCanonicalPath());
        boolean bl = debugMode = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") >= 0 && ProxyRunner.isDebuggerListening(8001);
        if (debugMode) {
            launchParams.javaToolOptions.add("-agentlib:jdwp=transport=dt_socket,address=localhost:8001");
        }
        launchParams.environmentVariables.put("ORQA_AUTO_CLOSE", Boolean.toString(autoClose));
        if (SupplementalLogUtils.isProxyLogEnabled()) {
            launchParams.environmentVariables.put("--logFile", SupplementalLogUtils.getProxyLogFile("proxy", "log").getAbsolutePath());
        }
        if (allowSystemClassLoaderOverride) {
            ProxyRunner.setProxySystemClassLoaderIfRequired(launchParams, proxyJar);
        }
        return launchParams;
    }

    private static void setProxySystemClassLoaderIfRequired(JavaAppLaunchParameters launchParams, File javaAgentJar) throws ZipException, FileNotFoundException, IOException, CoreException, InterruptedException {
        String wrappedSystemClassLoader;
        String defineSystemClassLoaderProp = "-Djava.system.class.loader";
        String argsSystemClassLoader = (String)ArgParser.getParamsMap(launchParams.jvmArgs).get(defineSystemClassLoaderProp);
        String toolOptsSystemClassLoader = (String)ArgParser.getParamsMap(launchParams.javaToolOptions).get(defineSystemClassLoaderProp);
        String string = wrappedSystemClassLoader = argsSystemClassLoader != null ? argsSystemClassLoader : toolOptsSystemClassLoader;
        if (StringUtils.isEmptyOrNull((String)wrappedSystemClassLoader)) {
            return;
        }
        launchParams.jvmArgs = ArgParser.removeParam((String)defineSystemClassLoaderProp, launchParams.jvmArgs);
        launchParams.javaToolOptions = ArgParser.removeParam((String)defineSystemClassLoaderProp, launchParams.javaToolOptions);
        launchParams.javaToolOptions.add(defineSystemClassLoaderProp + "=" + ProxySystemClassLoader.class.getCanonicalName());
        launchParams.javaToolOptions.add("-Dcrash=true");
        launchParams.javaToolOptions.add("-DjavaProxyWrappedSystemClassLoader=" + wrappedSystemClassLoader);
        int javaMajorVersion = JvmTools.getJvmMajorVersion((File)launchParams.executable);
        if (javaMajorVersion >= 9) {
            ProxyRunner.appendToClassPath(launchParams, javaAgentJar.getAbsolutePath());
        }
    }

    private static void appendToClassPath(JavaAppLaunchParameters launchParams, String ... classPaths) throws ZipException, FileNotFoundException, IOException, CoreException {
        String newClassPaths = ProxyRunner.concatenateClassPaths("", classPaths);
        if (newClassPaths.isBlank()) {
            return;
        }
        if (launchParams.jvmArgs.contains("-jar")) {
            ProxyRunner.convertJarToAppClassCommand(launchParams);
        }
        int cpSwitchIndex = -1;
        for (String cpSwitch : JVM_CLASS_PATH_ARGS) {
            cpSwitchIndex = Math.max(cpSwitchIndex, launchParams.jvmArgs.lastIndexOf(cpSwitch));
        }
        if (cpSwitchIndex != -1) {
            ArrayList<String> result = new ArrayList<String>();
            int cpIndex = cpSwitchIndex + 1;
            result.addAll(launchParams.jvmArgs.subList(0, cpIndex));
            if (cpIndex < launchParams.jvmArgs.size()) {
                newClassPaths = ProxyRunner.concatenateClassPaths(launchParams.jvmArgs.get(cpIndex), newClassPaths);
            }
            result.add(newClassPaths);
            if (launchParams.jvmArgs.size() > cpIndex + 1) {
                result.addAll(launchParams.jvmArgs.subList(cpIndex + 1, launchParams.jvmArgs.size()));
            }
            launchParams.jvmArgs = result;
            return;
        }
        if (launchParams.envClassPath.isBlank()) {
            launchParams.envClassPath = ".";
        }
        launchParams.envClassPath = ProxyRunner.concatenateClassPaths(launchParams.envClassPath, newClassPaths);
    }

    private static String concatenateClassPaths(String oldClassPaths, String ... newClassPaths) {
        StringBuilder classPathBuilder = new StringBuilder();
        if (!StringUtils.isEmptyOrNull((String)oldClassPaths)) {
            classPathBuilder.append(oldClassPaths.trim());
        }
        String[] stringArray = newClassPaths;
        int n = newClassPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String newClassPath = stringArray[n2];
            if (!StringUtils.isEmptyOrNull((String)newClassPath)) {
                if (!classPathBuilder.isEmpty()) {
                    classPathBuilder.append(CLASSPATH_SEPARATOR);
                }
                classPathBuilder.append(newClassPath);
            }
            ++n2;
        }
        return classPathBuilder.toString();
    }

    private static Map.Entry<List<String>, List<String>> splitJvmAndAppArgs(File executable, List<String> args) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appArgs = new ArrayList<String>();
        if (!JAVA_EXECUTABLES.contains(executable.getName().toLowerCase())) {
            appArgs.addAll(args);
            return new AbstractMap.SimpleEntry<List<String>, List<String>>(jvmArgs, appArgs);
        }
        boolean inJvmArgs = true;
        int i = 0;
        while (i < args.size()) {
            String arg = args.get(i);
            if (!inJvmArgs) {
                appArgs.add(arg);
            } else {
                String previousArg;
                jvmArgs.add(arg);
                String string = previousArg = i > 0 ? args.get(i - 1) : "";
                if (!arg.startsWith("-") && !JVM_2_PART_ARGS.contains(previousArg)) {
                    inJvmArgs = false;
                }
                if (previousArg.equals("-jar")) {
                    inJvmArgs = false;
                }
            }
            ++i;
        }
        return new AbstractMap.SimpleEntry<List<String>, List<String>>(jvmArgs, appArgs);
    }

    private static void convertJarToAppClassCommand(JavaAppLaunchParameters launchParams) throws ZipException, FileNotFoundException, IOException, CoreException {
        byte[] manifestBytes;
        Attributes manifest;
        String mainClass;
        int jarIndex = launchParams.jvmArgs.indexOf("-jar");
        if (jarIndex == -1 || jarIndex == launchParams.jvmArgs.size() - 1) {
            return;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(launchParams.jvmArgs.subList(0, jarIndex));
        String jarPath = launchParams.jvmArgs.get(jarIndex + 1);
        File jarFile = new File(jarPath);
        if (!jarFile.isAbsolute()) {
            jarFile = new File(launchParams.workingDirectory, jarPath);
        }
        if (StringUtils.isEmptyOrNull((String)(mainClass = (manifest = new Manifest(new ByteArrayInputStream(manifestBytes = ZipUtils.unzipFile((Object)jarFile, (String)"META-INF/MANIFEST.MF"))).getMainAttributes()).getValue("Main-Class")))) {
            throw new IllegalArgumentException(String.format("Main-Class not specified in MANIFEST of %s", jarFile.getAbsoluteFile()));
        }
        String manifestClassPath = StringUtils.blankIfEmpty((String)manifest.getValue("Class-Path"));
        StringBuilder classPath = new StringBuilder(jarFile.getAbsolutePath());
        String[] stringArray = manifestClassPath.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            if (!(entry = ProxyRunner.decodeManifestClassPathEntry(entry).trim()).isBlank()) {
                classPath.append(CLASSPATH_SEPARATOR).append(entry);
            }
            ++n2;
        }
        result.add("-cp");
        result.add(classPath.toString());
        result.add(mainClass);
        if (launchParams.jvmArgs.size() > jarIndex + 2) {
            result.addAll(launchParams.jvmArgs.subList(jarIndex + 2, launchParams.jvmArgs.size()));
        }
        launchParams.jvmArgs = result;
    }

    private static String decodeManifestClassPathEntry(String classPathEntry) {
        if (classPathEntry.isBlank()) {
            return classPathEntry;
        }
        try {
            URI url = new URI(classPathEntry);
            return URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException | URISyntaxException exception) {
            return classPathEntry;
        }
    }

    public static ProxySession attachRmiProcess(String givenSessionName, String sessionName, String windowName, List<Integer> pidsToIgnore) throws Exception {
        return ProxyRunner.attachRmiProcess(givenSessionName, sessionName, null, windowName, pidsToIgnore);
    }

    public static ProxySession attachRmiProcess(String givenSessionName, String sessionName, int pid) throws Exception {
        return ProxyRunner.attachRmiProcess(givenSessionName, sessionName, pid, null, null);
    }

    private static ProxySession attachRmiProcess(String givenSessionName, String sessionName, Integer pid, String windowName, List<Integer> pidsToIgnore) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ProxySessionManager.class.getClassLoader());
        try {
            HashMap<Integer, String> jdks = JavaAutomationPreferences.getJdks();
            RmiRegistryController registryController = new RmiRegistryController();
            Integer port = registryController.getRegistryPort();
            RmiRegistryController.bind((String)"ORQA_RMI_LOG_CALLBACK", (int)port, (Remote)new LogCallBack());
            boolean wrongArchitectureProcesses = false;
            for (Map.Entry<Integer, String> entry : jdks.entrySet()) {
                Map.Entry<Integer, String> result;
                block19: {
                    String jdk = entry.getValue();
                    Integer architecture = entry.getKey();
                    ArrayList<String> args = new ArrayList<String>();
                    if (SupplementalLogUtils.isProxyLogEnabled()) {
                        args.add("--logFile=" + SupplementalLogUtils.getProxyLogFile("proxy-attacher", "log").getAbsolutePath());
                    }
                    args.add("--attach");
                    args.add("--proxyRmiPort=" + String.valueOf(port));
                    args.add("--sessionName=" + sessionName);
                    if (pid != null) {
                        args.add("--pid=" + String.valueOf(pid));
                    } else {
                        Object pidIgnoreString = "";
                        for (int pidToIgnore : pidsToIgnore) {
                            pidIgnoreString = (String)pidIgnoreString + String.valueOf(((String)pidIgnoreString).isEmpty() ? Integer.valueOf(pidToIgnore) : "," + pidToIgnore);
                        }
                        args.add("--windowName=" + windowName);
                        args.add("--pidsToIgnore=" + (String)pidIgnoreString);
                    }
                    result = ProxyRunner.runAttacherJar(jdk, architecture, args);
                    if (result.getKey() != 0) break block19;
                    IAutomationProxy remote = (IAutomationProxy)RmiRegistryController.lookup((String)"ORQA_RMI_CLASS", (int)port);
                    ProxySession proxySession = new ProxySession(givenSessionName, sessionName, registryController, remote);
                    return proxySession;
                }
                try {
                    String stdOut = result.getValue().trim();
                    String[] stringArray = stdOut.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (line.startsWith("wrongArchitecture")) {
                            wrongArchitectureProcesses = true;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    registryController.stopRMIRegistry();
                    throw e;
                }
            }
            registryController.stopRMIRegistry();
            Object errorMessage = "Application not found";
            if (wrongArchitectureProcesses) {
                String missingArchitecture = null;
                if (!jdks.containsKey(32)) {
                    missingArchitecture = "32-bit";
                } else if (!jdks.containsKey(64)) {
                    missingArchitecture = "64-bit";
                }
                if (missingArchitecture != null) {
                    errorMessage = (String)errorMessage + String.format("; %s applications weren't checked since the %s JDK preference wasn't set", missingArchitecture, missingArchitecture);
                    throw new JdkConfigurationException((String)errorMessage);
                }
            }
            throw new Exception((String)errorMessage);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static Map.Entry<Integer, String> runAttacherJar(String jdk, int architecture, List<String> args) throws Exception {
        boolean debugMode;
        String attacherJar = JarUtils.findPluginJar((String)"orqa-automation-java-proxy");
        String javaExecutable = ProxyRunner.findJava(jdk, "java");
        File javaExecutableFile = new File(javaExecutable);
        if (!javaExecutableFile.isFile() || !JvmTools.isJdk((String)jdk)) {
            throw new JdkConfigurationException("Couldn't find JDK at: " + jdk);
        }
        String toolsJar = JvmTools.findJdkComponent((String)"lib", (String)"tools.jar", (String)jdk);
        int javaMajorVersion = JvmTools.getJvmMajorVersion((File)javaExecutableFile);
        if (toolsJar == null && javaMajorVersion > 0 && javaMajorVersion < 9) {
            throw new JdkConfigurationException("Couldn't find tools.jar in JDK at: " + jdk);
        }
        String separator = System.getProperty("path.separator");
        Object classPath = attacherJar;
        if (toolsJar != null) {
            classPath = (String)classPath + separator + toolsJar;
        }
        ArrayList<String> processArgs = new ArrayList<String>();
        processArgs.add(javaExecutable);
        boolean bl = debugMode = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") >= 0 && ProxyRunner.isDebuggerListening(8003);
        if (debugMode) {
            processArgs.add("-agentlib:jdwp=transport=dt_socket,address=localhost:8003");
        }
        if (javaMajorVersion >= 9) {
            processArgs.addAll(Arrays.asList("--add-opens", "jdk.attach/sun.tools.attach=ALL-UNNAMED"));
        }
        processArgs.addAll(Arrays.asList("-cp", classPath, "org.ibboost.orqa.automation.java.proxy.ProxyLauncher"));
        processArgs.add("--architecture=" + architecture);
        processArgs.add("--agentJar=" + attacherJar);
        processArgs.addAll(args);
        ProcessBuilder builder = new ProcessBuilder(processArgs);
        Process attacher = ProcessUtils.startProcess((ProcessBuilder)builder, (String)"Java Automation Attacher");
        JavaProcessOutputConsumer processOutputConsumer = new JavaProcessOutputConsumer(attacher, true, false);
        int result = attacher.waitFor();
        String stdErr = processOutputConsumer.getStdErr();
        if (!stdErr.trim().isEmpty()) {
            LOG.log(Logger.Level.ERROR, stdErr);
        } else if (result == 2) {
            throw new JdkConfigurationException(String.format("JDK '%s' is the wrong architecture, was expecting %d-bit", jdk, architecture));
        }
        return new AbstractMap.SimpleEntry<Integer, String>(result, processOutputConsumer.getStdOut());
    }

    private static File evaluateExecutable(String executable, String jvmPath, File workingDirectory) throws Exception {
        File exe = new File(executable);
        if (exe.isAbsolute()) {
            if (exe.isFile()) {
                return exe;
            }
            if (OSUtils.isWindows() && !executable.toLowerCase().endsWith(".exe") && (exe = new File(executable + ".exe")).isFile()) {
                return exe;
            }
            throw new Exception(String.format("Could not find java executable at %s", executable));
        }
        exe = new File(ProxyRunner.findJava(jvmPath, executable));
        if (exe.isFile()) {
            return exe;
        }
        exe = new File(workingDirectory, executable);
        if (exe.isFile()) {
            return exe;
        }
        if (OSUtils.isWindows() && !executable.toLowerCase().endsWith(".exe") && (exe = new File(workingDirectory, executable + ".exe")).isFile()) {
            return exe;
        }
        throw new Exception(String.format("Could not find %s in jvm %s or working directory %s", executable, jvmPath, workingDirectory.getAbsolutePath()));
    }

    private static String findJava(String givenPath, String exeName) {
        File javaDir;
        String fullComparablePath = ProxyRunner.normalisePath(givenPath);
        for (String executableName : JAVA_EXECUTABLES) {
            if (!fullComparablePath.endsWith("/" + executableName) || !new File(givenPath).isFile() && (givenPath.toLowerCase().endsWith(".exe") || !new File(givenPath + ".exe").isFile())) continue;
            givenPath = new File(givenPath).getParent();
            break;
        }
        if (ProxyRunner.normalisePath(givenPath).endsWith("/bin")) {
            givenPath = givenPath.substring(0, givenPath.length() - 4);
        }
        if (ProxyRunner.normalisePath(givenPath).endsWith("/jre") && ProxyRunner.normalisePath(exeName).startsWith("jre/")) {
            exeName = exeName.substring(4);
        }
        if ((javaDir = new File(givenPath)).isDirectory()) {
            ArrayList<String> possibleLocations = new ArrayList<String>(Arrays.asList(exeName, "bin/" + exeName));
            if (!exeName.endsWith(".exe")) {
                possibleLocations.addAll(Arrays.asList(exeName + ".exe", "bin/" + exeName + ".exe"));
            }
            for (String location : possibleLocations) {
                File fileLocation = new File(javaDir.getPath() + "/" + location);
                if (!fileLocation.exists()) continue;
                return fileLocation.getPath();
            }
        }
        return givenPath;
    }

    private static String normalisePath(String path) {
        return path.toLowerCase().replaceAll("\\\\", "/");
    }

    static HashMap<Integer, String> getCommandLineArgs(List<Integer> pids) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (ProcessUtils.ProcessInfo proc : ProcessUtils.getProcessList()) {
            if (!pids.contains(proc.getPid())) continue;
            result.put(proc.getPid(), proc.getCommand());
        }
        return result;
    }

    private static class JavaAppLaunchParameters {
        public File executable;
        public List<String> jvmArgs = new ArrayList<String>();
        public List<String> appArgs = new ArrayList<String>();
        public String envClassPath;
        public File workingDirectory;
        public List<String> javaToolOptions = new ArrayList<String>();
        public Map<String, String> environmentVariables = new LinkedHashMap<String, String>();

        private JavaAppLaunchParameters() {
        }
    }

    public static class JdkConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JdkConfigurationException(String message) {
            super(message);
        }
    }
}

