/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ibboost.orqa.automation.java.common.IProxyCallBack;
import org.ibboost.orqa.automation.java.common.RMILoopbackSocketFactory;

public class ProxyCallBack
extends UnicastRemoteObject
implements IProxyCallBack {
    private static final long serialVersionUID = 1L;
    private static final RMILoopbackSocketFactory SOCKET_FACTORY = new RMILoopbackSocketFactory();
    final CountDownLatch blockForeverLatch = new CountDownLatch(1);
    final CountDownLatch registrationLatch = new CountDownLatch(1);

    public ProxyCallBack() throws RemoteException {
        super(0, (RMIClientSocketFactory)SOCKET_FACTORY, (RMIServerSocketFactory)SOCKET_FACTORY);
    }

    public void stop() {
        this.blockForeverLatch.countDown();
    }

    public boolean waitForRegistration(int timeout) {
        try {
            return this.registrationLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void registerAttachment() throws RemoteException {
        this.registrationLatch.countDown();
    }

    public void blockUntilHostCloses() throws RemoteException {
        try {
            this.blockForeverLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

