/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.ibboost.orqa.automation.java.AttachableJavaWindow;
import org.ibboost.orqa.automation.java.JavaAutomationActivator;
import org.ibboost.orqa.automation.java.JavaAutomationPreferences;
import org.ibboost.orqa.automation.java.ProxyRunner;
import org.ibboost.orqa.core.execution.results.ExceptionMessages;
import org.ibboost.orqa.core.ui.editors.IEditorValuePicker;
import org.ibboost.orqa.core.ui.editors.PropertyEditor;

public class ProcessPicker
implements IEditorValuePicker {
    public synchronized void open(final Shell shell, final PropertyEditor<?> pickerEditor, final Map<String, PropertyEditor<?>> propertyPageEditorSet) {
        if (!JavaAutomationPreferences.isJdkConfigured()) {
            JavaAutomationPreferences.openPreferencesDialog();
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    final List<AttachableJavaWindow> windows = ProxyRunner.getAttachableWindows(true);
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProcessPicker.this.showDialog(shell, pickerEditor, propertyPageEditorSet, windows);
                        }
                    });
                }
                catch (Exception e) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)shell, (String)"Error Searching for Java Apps", null, (IStatus)new Status(4, JavaAutomationActivator.PLUGIN_ID, ExceptionMessages.getExceptionMessage((Throwable)e)));
                        }
                    });
                }
            }
        }.start();
    }

    private void showDialog(Shell shell, PropertyEditor<?> pickerEditor, Map<String, PropertyEditor<?>> propertyPageEditorSet, List<AttachableJavaWindow> windows) {
        ListDialog dialog = new ListDialog(shell);
        dialog.setInput(windows);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                AttachableJavaWindow attachableWindow = (AttachableJavaWindow)element;
                return attachableWindow.getTitle() + " (" + attachableWindow.getCommandLineArgs() + ")";
            }
        });
        dialog.setTitle("Select Java Process");
        dialog.setMessage("Choose a running java process to copy the start command from:");
        int result = dialog.open();
        if (result == 0 && dialog.getResult().length > 0) {
            String jvmPath;
            String workingDirectory;
            AttachableJavaWindow window = (AttachableJavaWindow)dialog.getResult()[0];
            pickerEditor.setValue(window.getCommandLineArgs());
            String string = workingDirectory = window.getWorkingDirectory() != null ? window.getWorkingDirectory() : "";
            if (propertyPageEditorSet.containsKey("pwd")) {
                propertyPageEditorSet.get("pwd").setValue(workingDirectory);
            }
            String string2 = jvmPath = window.getJvmPath() != null ? window.getJvmPath() : "";
            if (propertyPageEditorSet.containsKey("jvm")) {
                propertyPageEditorSet.get("jvm").setValue(jvmPath);
            }
        }
    }
}

